/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material.generated;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.redpxnda.nucleus.util.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.material.DelegatingMaterial;
import smartin.miapi.material.MaterialIcons;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.generated.GeneratedMaterialManager;
import smartin.miapi.material.generated.GeneratedMaterialPropertyManager;
import smartin.miapi.material.generated.MaterialHelper;
import smartin.miapi.material.generated.NamingUtil;
import smartin.miapi.material.generated.TierManager;
import smartin.miapi.material.palette.FallbackColorer;
import smartin.miapi.material.palette.GrayscalePaletteColorer;
import smartin.miapi.material.palette.MaterialRenderController;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.attributes.AttributeUtil;
import smartin.miapi.modules.properties.tag.ModuleTagProperty;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class GeneratedMaterial
implements Material {
    ItemStack mainIngredient = ItemStack.EMPTY;
    Ingredient ingredient = Ingredient.EMPTY;
    ResourceLocation key = Miapi.id("empty_material");
    List<String> groups = new ArrayList<String>();
    List<String> textureKeys = new ArrayList<String>();
    public Map<String, Double> stats = new HashMap<String, Double>();
    List<ArmorItem> armorItems = new ArrayList<ArmorItem>();
    TagKey<Block> incorrectForTool = BlockTags.INCORRECT_FOR_WOODEN_TOOL;
    GrayscalePaletteColorer palette;
    @Nullable
    MaterialIcons.MaterialIcon icon;
    final Tier toolMaterial;
    boolean isValid = false;
    SwordItem swordItem;
    List<TieredItem> toolItems;
    Optional<ResourceLocation> smithingParent = Optional.empty();
    Component name = null;
    public Map<String, Map<ModuleProperty<?>, Object>> properties = new HashMap();
    SmithingMode smithingMode = SmithingMode.NONE;
    ItemStack smithingTemplate = ItemStack.EMPTY;
    Optional<Float> armorHardness = Optional.empty();
    public static Codec<GeneratedMaterial> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.CODEC.fieldOf("main_ingredient").forGetter(m -> m.mainIngredient), (App)Ingredient.CODEC.fieldOf("ingredient").forGetter(m -> m.ingredient), (App)ItemStack.CODEC.fieldOf("sword").forGetter(m -> m.swordItem.getDefaultInstance()), (App)Codec.list((Codec)ItemStack.CODEC).fieldOf("toolItems").forGetter(m -> m.toolItems.stream().map(Item::getDefaultInstance).toList()), (App)Codec.FLOAT.optionalFieldOf("armor_hardness").forGetter(m -> m.armorHardness), (App)ResourceLocation.CODEC.optionalFieldOf("smithing_key").forGetter(m -> m.smithingParent), (App)ItemStack.CODEC.optionalFieldOf("smithing_template", (Object)ItemStack.EMPTY).forGetter(m -> m.swordItem.getDefaultInstance())).apply((Applicative)instance, (itemstack, additionalIngredient, swordItem, ingredient_toolItems, armor, smithingKey, smithingItem) -> {
        GeneratedMaterial material = new GeneratedMaterial((ItemStack)itemstack, (Ingredient)additionalIngredient, ((SwordItem)swordItem.getItem()).getTier(), ingredient_toolItems.stream().map(itemStack -> (TieredItem)itemStack.getItem()).toList());
        if (smithingKey != null && smithingKey.isPresent()) {
            material.setSmithingMaterial((ResourceLocation)smithingKey.get(), Ingredient.of((ItemStack[])new ItemStack[]{smithingItem}));
        }
        armor.ifPresent(aFloat -> material.stats.put("armor_hardness", Double.valueOf(aFloat.floatValue())));
        return material;
    }));

    public GeneratedMaterial(ItemStack mainIngredient, Ingredient ingredient, Tier sourceTier, List<TieredItem> toolItems) {
        this.key = Miapi.id("generated/" + mainIngredient.getDescriptionId() + toolItems.getFirst().getDescriptionId());
        this.toolMaterial = sourceTier;
        this.ingredient = ingredient;
        this.toolItems = toolItems;
        this.mainIngredient = mainIngredient;
        this.groups.add(this.key.toString());
        this.textureKeys = List.of("default");
        if (mainIngredient.getDescriptionId().contains("ingot")) {
            this.groups.add("metal");
        }
        if (mainIngredient.getDescriptionId().contains("stone")) {
            this.groups.add("stone");
        }
        if (mainIngredient.getDescriptionId().contains("bone")) {
            this.groups.add("bone");
        }
        if (mainIngredient.is(ItemTags.PLANKS)) {
            this.groups.add("wood");
        }
        if (this.groups.size() == 1) {
            this.groups.add("crystal");
        }
        if (Environment.isClient()) {
            // empty if block
        }
        this.stats.put("durability", (double)this.toolMaterial.getUses() - 15.0);
        this.stats.put("mining_speed", Double.valueOf(this.toolMaterial.getSpeed()));
        this.stats.put("enchantability", Double.valueOf(this.toolMaterial.getEnchantmentValue()));
        this.isValid = this.assignStats(toolItems);
        this.incorrectForTool = sourceTier.getIncorrectBlocksForDrops();
    }

    public boolean assignStats(List<TieredItem> toolItems) {
        Item item;
        List<Item> toolMaterials = toolItems.stream().filter(material -> this.toolMaterial.equals((Object)material.getTier())).collect(Collectors.toList());
        Optional<Item> swordItemOptional = toolMaterials.stream().filter(SwordItem.class::isInstance).findFirst();
        Optional<Item> axeItemOptional = toolMaterials.stream().filter(AxeItem.class::isInstance).findFirst();
        if (swordItemOptional.isPresent() && axeItemOptional.isPresent() && (item = swordItemOptional.get()) instanceof SwordItem) {
            SwordItem foundSwordItem = (SwordItem)item;
            item = axeItemOptional.get();
            if (item instanceof DiggerItem) {
                DiggerItem axeItem = (DiggerItem)item;
                this.swordItem = foundSwordItem;
                this.key = Miapi.id("generated/" + this.mainIngredient.getDescriptionId() + this.swordItem.getDescriptionId());
                double swordAttackDmg = AttributeUtil.getActualValue(this.swordItem.getDefaultInstance(), EquipmentSlot.MAINHAND, (Attribute)Attributes.ATTACK_DAMAGE.value(), 0.0);
                double axeAttackDmg = AttributeUtil.getActualValue(axeItem.getDefaultInstance(), EquipmentSlot.MAINHAND, (Attribute)Attributes.ATTACK_DAMAGE.value(), 0.0);
                double calculatedDamage = Math.floor(Math.pow((swordAttackDmg - 3.4) * 2.3, 0.3333333333333333)) + 7.0;
                this.stats.put("hardness", swordAttackDmg);
                if (this.groups.contains("stone")) {
                    this.stats.put("density", swordAttackDmg / 1.5);
                } else if (this.groups.contains("crystal")) {
                    this.stats.put("density", swordAttackDmg / 2.5);
                } else {
                    this.stats.put("density", swordAttackDmg / 2.0);
                }
                if (Math.abs(calculatedDamage - axeAttackDmg) > 0.1) {
                    this.stats.put("axe_damage", -(calculatedDamage - axeAttackDmg));
                }
                if (this.groups.contains("crystal") || this.groups.contains("gemstone")) {
                    this.stats.put("flexibility", 0.0);
                } else {
                    this.stats.put("flexibility", Double.valueOf(this.toolMaterial.getSpeed() / 4.0f));
                }
                this.stats.put("tier", Double.valueOf(TierManager.getEstimatedTier((TagKey<Block>)this.toolMaterial.getIncorrectBlocksForDrops())));
                this.armorItems = this.findRelatedArmorItems();
                if (this.armorItems.size() == 4) {
                    double totalArmor = (int)this.armorItems.stream().collect(Collectors.summarizingInt(ArmorItem::getDefense)).getSum();
                    double desiredHardness = (totalArmor + this.stats.get("flexibility") / 4.0 + this.stats.get("density") / 4.0 - 1.0) / 4.05;
                    double max = Math.max(totalArmor, desiredHardness);
                    if (!(Math.abs(totalArmor - desiredHardness) <= 0.15 * max)) {
                        Miapi.LOGGER.info("replacement hardness " + desiredHardness + " original " + String.valueOf(this.stats.get("hardness")));
                        this.stats.put("armor_hardness", desiredHardness);
                    }
                }
                this.properties = GeneratedMaterialPropertyManager.setup(this.getID(), this.swordItem, axeItem, toolMaterials, this.armorItems, Map.of());
                return true;
            }
        }
        return false;
    }

    @Override
    public Material getMaterial(ModuleInstance moduleInstance, Map<ModuleProperty<?>, Object> properties) {
        if (ModuleTagProperty.getTags(moduleInstance).contains("armor") && this.stats.containsKey("armor_hardness")) {
            return new DelegatingMaterial(this){

                @Override
                public double getDouble(String property) {
                    if (property.equals("hardness")) {
                        if (GeneratedMaterialManager.verboseLogging()) {
                            Miapi.LOGGER.info("returning hardness " + String.valueOf(GeneratedMaterial.this.stats.get("armor_hardness")));
                        }
                        return GeneratedMaterial.this.stats.get("armor_hardness");
                    }
                    if (GeneratedMaterial.this.stats.containsKey(property)) {
                        return GeneratedMaterial.this.stats.get(property);
                    }
                    return 0.0;
                }
            };
        }
        return this;
    }

    public List<ArmorItem> findRelatedArmorItems() {
        return BuiltInRegistries.ITEM.stream().filter(ArmorItem.class::isInstance).map(r -> (ArmorItem)r).filter(armorItem -> {
            block3: {
                try {
                    if (((ArmorMaterial)armorItem.getMaterial().value()).repairIngredient() != null) {
                        return ((Ingredient)((ArmorMaterial)armorItem.getMaterial().value()).repairIngredient().get()).test(this.mainIngredient);
                    }
                }
                catch (RuntimeException e) {
                    if (!GeneratedMaterialManager.verboseLogging()) break block3;
                    Miapi.LOGGER.error("Error during armor test", (Throwable)e);
                }
            }
            return false;
        }).toList();
    }

    public SwordItem getSwordItem() {
        return this.swordItem;
    }

    public void setSmithingMaterial(ResourceLocation other, Ingredient ingredient) {
        this.smithingParent = Optional.of(other);
        Material otherMat = MaterialProperty.getMaterialFromIngredient(this.mainIngredient);
        if (GeneratedMaterialManager.verboseLogging()) {
            Miapi.LOGGER.info("other mat for smithing test " + String.valueOf(otherMat));
        }
        if (otherMat == null || this.equals(otherMat) || otherMat.getID().equals((Object)this.getID())) {
            this.smithingMode = SmithingMode.INGREDIENT;
            this.groups = List.of("smithing");
        } else {
            this.smithingMode = SmithingMode.TEMPLATE;
            if (otherMat != null) {
                otherMat.addSmithingGroup();
            }
            if (!ingredient.isEmpty() && ingredient.getItems() != null && ingredient.getItems()[0] != null && !ingredient.getItems()[0].isEmpty()) {
                this.smithingTemplate = ingredient.getItems()[0];
            }
        }
    }

    @Override
    public void addSmithingGroup() {
        if (!this.groups.contains("smithing")) {
            this.groups = new ArrayList<String>(List.of("smithing"));
        }
    }

    @Override
    public Component getTranslation() {
        if (this.name == null) {
            this.name = Component.literal((String)NamingUtil.generateTranslation(this.toolItems, this.mainIngredient));
        }
        return this.name;
    }

    public boolean isValid() {
        return this.isValid;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setupClient() {
        this.palette = GrayscalePaletteColorer.createForGeneratedMaterial(this, this.mainIngredient);
        this.icon = new MaterialIcons.ItemMaterialIcon(this.mainIngredient, 18, null);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int renderIcon(GuiGraphics drawContext, int x, int y) {
        if (this.icon == null) {
            return 0;
        }
        return this.icon.render(drawContext, x, y);
    }

    @Override
    public boolean hasIcon() {
        return true;
    }

    @Override
    public ResourceLocation getID() {
        return this.key;
    }

    @Override
    public List<String> getGroups() {
        return this.groups;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public MaterialRenderController getRenderController(ModuleInstance context, ItemDisplayContext mode) {
        if (this.palette == null) {
            return new FallbackColorer(this);
        }
        return this.palette;
    }

    @Override
    public Map<ModuleProperty<?>, Object> materialProperties(String key) {
        return this.properties.getOrDefault(key, Map.of());
    }

    @Override
    public List<String> getAllPropertyKeys() {
        return this.properties.keySet().stream().toList();
    }

    @Override
    public double getDouble(String property) {
        if (this.stats.containsKey(property)) {
            return this.stats.get(property);
        }
        return 0.0;
    }

    @Override
    public String getData(String property) {
        return null;
    }

    @Override
    public List<String> getTextureKeys() {
        return this.textureKeys;
    }

    @Override
    public double getValueOfItem(ItemStack itemStack) {
        if (!this.smithingMode.equals((Object)SmithingMode.TEMPLATE)) {
            if (this.mainIngredient.getItem().equals(itemStack.getItem())) {
                return 1.0;
            }
            if (this.ingredient.test(itemStack)) {
                return 1.0;
            }
        }
        return 0.0;
    }

    @Override
    public double getRepairValueOfItem(ItemStack itemStack) {
        if (this.mainIngredient.getItem().equals(itemStack.getItem())) {
            return 1.0;
        }
        if (this.ingredient.test(itemStack)) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    @Nullable
    public Double getPriorityOfIngredientItem(ItemStack itemStack) {
        if (!this.smithingMode.equals((Object)SmithingMode.TEMPLATE)) {
            if (this.mainIngredient.getItem().equals(itemStack.getItem())) {
                return -10.0;
            }
            if (this.ingredient.test(itemStack)) {
                return -1.0;
            }
        } else if (itemStack.getItem().equals(this.smithingTemplate.getItem())) {
            return 1.0;
        }
        return null;
    }

    @Override
    public TagKey<Block> getIncorrectBlocksForDrops() {
        return this.incorrectForTool;
    }

    @Override
    public JsonObject getDebugJson() {
        try {
            return MaterialHelper.toCodecMaterial(this).getDebugJson();
        }
        catch (RuntimeException e) {
            Miapi.LOGGER.warn("could not convert generated material", (Throwable)e);
            JsonObject object = new JsonObject();
            object.add("id", (JsonElement)new JsonPrimitive(this.getID().toString()));
            JsonArray jsonElements = new JsonArray();
            this.getTextureKeys().forEach(arg_0 -> ((JsonArray)jsonElements).add(arg_0));
            object.add("groups", (JsonElement)jsonElements);
            this.stats.forEach((arg_0, arg_1) -> ((JsonObject)object).addProperty(arg_0, arg_1));
            if (Environment.isClient()) {
                object.addProperty("fake_translation", this.getTranslation().getString());
                ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)this.mainIngredient.getItem());
                String iconBuilder = "{\"type\": \"item\",\"item\": \"" + String.valueOf(itemId) + "\"}";
                object.add("icon", (JsonElement)Miapi.gson.fromJson(iconBuilder, JsonObject.class));
            }
            if (this.palette != null) {
                StringBuilder paletteBuilder = new StringBuilder();
                paletteBuilder.append("{");
                paletteBuilder.append("\"type\": \"").append("grayscale_map").append("\",");
                paletteBuilder.append("\"colors\": ");
                JsonObject innerPalette = new JsonObject();
                for (int i = 0; i < this.palette.getColors().length; ++i) {
                    int abgr = this.palette.getColors()[i];
                    innerPalette.addProperty(String.valueOf(i), new Color(FastColor.ABGR32.red((int)abgr), FastColor.ABGR32.green((int)abgr), FastColor.ABGR32.blue((int)abgr), FastColor.ABGR32.alpha((int)abgr)).hex());
                }
                paletteBuilder.append(Miapi.gson.toJson((JsonElement)innerPalette));
                paletteBuilder.append("}");
                object.add("palette", (JsonElement)Miapi.gson.fromJson(paletteBuilder.toString(), JsonObject.class));
            }
            JsonArray ingredients = new JsonArray();
            JsonObject mainIngredientJson = new JsonObject();
            mainIngredientJson.add("item", (JsonElement)new JsonPrimitive(BuiltInRegistries.ITEM.getKey((Object)this.mainIngredient.getItem()).toString()));
            mainIngredientJson.add("value", (JsonElement)new JsonPrimitive((Number)1.0));
            JsonObject otherIngredient = new JsonObject();
            otherIngredient.add("ingredient", (JsonElement)Ingredient.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.toolMaterial.getRepairIngredient()).getOrThrow());
            otherIngredient.add("value", (JsonElement)new JsonPrimitive((Number)1.0));
            ingredients.add((JsonElement)mainIngredientJson);
            ingredients.add((JsonElement)otherIngredient);
            object.add("items", (JsonElement)ingredients);
            return object;
        }
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    static enum SmithingMode {
        NONE,
        TEMPLATE,
        INGREDIENT;

    }
}

