/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material.generated;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.crafting.Ingredient;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.generated.GeneratedMaterial;
import smartin.miapi.material.generated.GeneratedMaterialFromCopy;
import smartin.miapi.material.generated.SmithingRecipeUtil;
import smartin.miapi.registries.RegistryInventory;

public class GeneratedMaterialManager {
    public static final List<GeneratedMaterial> generatedMaterials = new ArrayList<GeneratedMaterial>();
    public static final List<GeneratedMaterialFromCopy> basicGeneratedMaterials = new ArrayList<GeneratedMaterialFromCopy>();
    public static List<GeneratedMaterialFromCopy.GeneratedMaterialCopy> TO_GENERATE = new ArrayList<GeneratedMaterialFromCopy.GeneratedMaterialCopy>();

    public static void setup() {
        ReloadEvents.MAIN.subscribe((isClient, registryAccess) -> {
            if (!isClient) {
                GeneratedMaterialManager.onReloadServer(registryAccess);
            } else {
                try {
                    basicGeneratedMaterials.forEach(generatedMaterial -> MaterialProperty.MATERIAL_REGISTRY.register(generatedMaterial.getID(), (Material)generatedMaterial));
                    SmithingRecipeUtil.setupSmithingRecipe(generatedMaterials, true, material -> MaterialProperty.MATERIAL_REGISTRY.register(material.getID(), (Material)material), registryAccess, null);
                }
                catch (RuntimeException e) {
                    Miapi.LOGGER.info("could not set up generated Materials on client!", (Throwable)e);
                }
                try {
                    basicGeneratedMaterials.clear();
                    for (GeneratedMaterialFromCopy.GeneratedMaterialCopy copy : TO_GENERATE) {
                        Material baseMaterial = MaterialProperty.MATERIAL_REGISTRY.get(copy.fromMaterial());
                        if (baseMaterial == null) {
                            Miapi.LOGGER.info("Cannot generate copy material based on missing base " + String.valueOf(copy.fromMaterial()));
                            continue;
                        }
                        GeneratedMaterialFromCopy material2 = new GeneratedMaterialFromCopy(copy.ingredient(), baseMaterial);
                        material2.setupClient();
                        if (GeneratedMaterialManager.verboseLogging()) {
                            Miapi.LOGGER.info("wood/stone " + material2.getTranslation().getString());
                        }
                        basicGeneratedMaterials.add(material2);
                    }
                }
                catch (RuntimeException e) {
                    Miapi.LOGGER.info("could not set up generated copy Materials on client!", (Throwable)e);
                }
            }
        }, -1.0f);
        ReloadEvents.DATA_SYNCER_REGISTRY.register(Miapi.id("generated_materials"), (ReloadEvents.DataSyncer)new ReloadEvents.SimpleSyncer<List<GeneratedMaterial>>(ByteBufCodecs.fromCodec((Codec)Codec.list(GeneratedMaterial.CODEC))){

            @Override
            public List<GeneratedMaterial> getDataServer() {
                return generatedMaterials;
            }

            @Override
            public void interpretData(List<GeneratedMaterial> data) {
                if (GeneratedMaterialManager.verboseLogging()) {
                    Miapi.LOGGER.info("Client received " + data.size() + " complex materials");
                }
                for (GeneratedMaterial material : data) {
                    material.setupClient();
                    if (!GeneratedMaterialManager.verboseLogging()) continue;
                    Miapi.LOGGER.info("complex " + material.getTranslation().getString());
                }
                generatedMaterials.clear();
                generatedMaterials.addAll(data);
            }
        });
        ReloadEvents.DATA_SYNCER_REGISTRY.register(Miapi.id("generated_simple_materials"), (ReloadEvents.DataSyncer)new ReloadEvents.SimpleSyncer<List<GeneratedMaterialFromCopy.GeneratedMaterialCopy>>(ByteBufCodecs.fromCodec((Codec)Codec.list(GeneratedMaterialFromCopy.CODEC))){

            @Override
            public List<GeneratedMaterialFromCopy.GeneratedMaterialCopy> getDataServer() {
                return basicGeneratedMaterials.stream().map(a -> new GeneratedMaterialFromCopy.GeneratedMaterialCopy(a.mainIngredient, a.source.getID())).toList();
            }

            @Override
            public void interpretData(List<GeneratedMaterialFromCopy.GeneratedMaterialCopy> data) {
                if (GeneratedMaterialManager.verboseLogging()) {
                    Miapi.LOGGER.info("Client received " + data.size() + " wood/stone materials");
                }
                TO_GENERATE = data;
            }
        });
    }

    public static Registry<Item> getRegistry() {
        if (Miapi.registryAccess == null) {
            return BuiltInRegistries.ITEM;
        }
        return (Registry)Miapi.registryAccess.registry(Registries.ITEM).get();
    }

    public static void onReloadServer(RegistryAccess access) {
        try {
            if (GeneratedMaterialManager.verboseLogging()) {
                Miapi.LOGGER.info("MIAPI STARTED MATERIAL GENERATION");
            }
            generatedMaterials.clear();
            basicGeneratedMaterials.clear();
            if (!MiapiConfig.getServerConfig().generatedMaterials.generateMaterials) {
                return;
            }
            Registry<Item> registiry = GeneratedMaterialManager.getRegistry();
            ArrayList<TieredItem> toolItems = new ArrayList<TieredItem>(registiry.stream().filter(TieredItem.class::isInstance).map(TieredItem.class::cast).filter(toolMaterial -> toolMaterial.getTier().getRepairIngredient() != null && toolMaterial.getTier().getRepairIngredient().getItems() != null && toolMaterial.getTier().getRepairIngredient().getItems().length > 0).filter(toolMaterial -> !toolMaterial.getTier().getRepairIngredient().getItems()[0].is(RegistryInventory.MIAPI_FORBIDDEN_TAG)).filter(GeneratedMaterialManager::isValidItem).filter(toolMaterial -> Arrays.stream(toolMaterial.getTier().getRepairIngredient().getItems()).allMatch(itemStack -> MaterialProperty.getMaterialFromIngredient(itemStack) == null && !itemStack.getItem().equals(Items.BARRIER))).toList());
            HashMap tieredItem = new HashMap();
            toolItems.forEach(item -> tieredItem.computeIfAbsent(item.getTier(), i -> new ArrayList()).add(item));
            HashMap<Tier, List> consolidated = new HashMap<Tier, List>();
            for (Map.Entry entry : tieredItem.entrySet()) {
                Tier currentTier = (Tier)entry.getKey();
                List currentItems = (List)entry.getValue();
                boolean merged = false;
                for (Map.Entry consolidatedEntry : consolidated.entrySet()) {
                    Tier existingTier = (Tier)consolidatedEntry.getKey();
                    if (!GeneratedMaterialManager.isSameTier(currentTier, existingTier)) continue;
                    ((List)consolidatedEntry.getValue()).addAll(currentItems);
                    merged = true;
                    break;
                }
                if (merged) continue;
                consolidated.put(currentTier, new ArrayList(currentItems));
            }
            HashMap<Tier, List> insufficientItems = new HashMap<Tier, List>();
            consolidated.forEach((t, items) -> {
                boolean hasSword = items.stream().anyMatch(SwordItem.class::isInstance);
                boolean hasAxe = items.stream().anyMatch(AxeItem.class::isInstance);
                if (!hasSword || !hasAxe) {
                    insufficientItems.put((Tier)t, (List)items);
                }
            });
            insufficientItems.forEach((t, items) -> consolidated.remove(t));
            if (MiapiConfig.getServerConfig().generatedMaterials.generateOtherMaterials) {
                consolidated.forEach((tier, tieredItems) -> {
                    GeneratedMaterial generatedMaterial;
                    ItemStack mainIngredient = tier.getRepairIngredient().getItems()[0];
                    if (GeneratedMaterialManager.verboseLogging()) {
                        Miapi.LOGGER.info("attempting material generation for " + mainIngredient.getHoverName().getString());
                    }
                    if (GeneratedMaterialManager.isValidItem(mainIngredient.getItem()) && (generatedMaterial = new GeneratedMaterial(mainIngredient, tier.getRepairIngredient(), (Tier)tier, (List<TieredItem>)tieredItems)).isValid()) {
                        if (GeneratedMaterialManager.verboseLogging()) {
                            Miapi.LOGGER.info("Generated Material " + String.valueOf(generatedMaterial.getID()));
                        }
                        generatedMaterials.add(generatedMaterial);
                    }
                });
            }
            if (MiapiConfig.getServerConfig().generatedMaterials.generateWoodMaterials) {
                BuiltInRegistries.ITEM.stream().filter(item -> item.getDefaultInstance().is(ItemTags.PLANKS) && !item.getDefaultInstance().is(RegistryInventory.MIAPI_FORBIDDEN_TAG)).limit(MiapiConfig.getServerConfig().generatedMaterials.maximumGeneratedMaterials).forEach(item -> {
                    try {
                        if (GeneratedMaterialManager.isValidItem(item)) {
                            Material old = MaterialProperty.getMaterialFromIngredient(item.getDefaultInstance());
                            Material baseWood = MaterialProperty.MATERIAL_REGISTRY.get(Miapi.id("wood/wood"));
                            if (old != null && baseWood != null && old == baseWood) {
                                GeneratedMaterialFromCopy generatedMaterial = new GeneratedMaterialFromCopy(item.getDefaultInstance(), old);
                                basicGeneratedMaterials.add(generatedMaterial);
                                if (GeneratedMaterialManager.verboseLogging()) {
                                    Miapi.LOGGER.info("Generated Wood Material " + String.valueOf(generatedMaterial.getID()));
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        Miapi.LOGGER.error("could not generate wood Material for " + item.getDescriptionId(), (Throwable)e);
                    }
                });
            }
            if (MiapiConfig.getServerConfig().generatedMaterials.generateStoneMaterials) {
                BuiltInRegistries.ITEM.stream().filter(item -> item.getDefaultInstance().is(ItemTags.STONE_TOOL_MATERIALS) && !item.getDefaultInstance().is(RegistryInventory.MIAPI_FORBIDDEN_TAG)).limit(MiapiConfig.getServerConfig().generatedMaterials.maximumGeneratedMaterials).forEach(item -> {
                    try {
                        if (GeneratedMaterialManager.isValidItem(item) && !item.equals(Items.COBBLESTONE)) {
                            Material old = MaterialProperty.getMaterialFromIngredient(item.getDefaultInstance());
                            Material baseStone = MaterialProperty.MATERIAL_REGISTRY.get(Miapi.id("stone/stone"));
                            if (old != null && baseStone != null && old == baseStone) {
                                GeneratedMaterialFromCopy generatedMaterial = new GeneratedMaterialFromCopy(item.getDefaultInstance(), old);
                                basicGeneratedMaterials.add(generatedMaterial);
                                if (GeneratedMaterialManager.verboseLogging()) {
                                    Miapi.LOGGER.info("Generated Stone Material " + String.valueOf(generatedMaterial.getID()));
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        Miapi.LOGGER.error("could not generate stone Material for " + item.getDescriptionId(), (Throwable)e);
                    }
                });
            }
            SmithingRecipeUtil.setupSmithingRecipe(generatedMaterials, false, material -> {
                if (material != null) {
                    MaterialProperty.MATERIAL_REGISTRY.register(material.getID(), (Material)material);
                    ((MiapiEvents.CreateMaterialModularConvertersEvent)MiapiEvents.GENERATE_MATERIAL_CONVERTERS.invoker()).generated((Material)material, material.toolItems, material.armorItems, Environment.isClient());
                }
            }, access, null);
            if (GeneratedMaterialManager.verboseLogging()) {
                Miapi.LOGGER.info("MIAPI FINISHED MATERIAL GENERATION");
            }
        }
        catch (Exception e) {
            Miapi.LOGGER.error("MAJOR ISSUE DURING MATERIAL CREATION", (Throwable)e);
        }
    }

    public static boolean isSameTier(Tier first, Tier second) {
        if (first.equals((Object)second)) {
            return true;
        }
        try {
            if (!first.getIncorrectBlocksForDrops().equals((Object)second.getIncorrectBlocksForDrops())) {
                return false;
            }
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
        try {
            if (!GeneratedMaterialManager.isSameIngredient(first.getRepairIngredient(), second.getRepairIngredient())) {
                return false;
            }
            if (GeneratedMaterialManager.percentDif(first.getAttackDamageBonus(), second.getAttackDamageBonus()) > 0.1) {
                return false;
            }
            if (GeneratedMaterialManager.percentDif(first.getSpeed(), second.getSpeed()) > 0.1) {
                return false;
            }
            if (GeneratedMaterialManager.percentDif(first.getUses(), second.getUses()) > 0.1) {
                return false;
            }
            if (GeneratedMaterialManager.percentDif(first.getEnchantmentValue(), second.getEnchantmentValue()) > 0.1) {
                return false;
            }
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
        return true;
    }

    public static double percentDif(int a, int b) {
        return GeneratedMaterialManager.percentDif((double)a, (double)b);
    }

    public static double percentDif(float a, float b) {
        return GeneratedMaterialManager.percentDif((double)a, (double)b);
    }

    public static double percentDif(double a, double b) {
        return Math.abs(a - b) / ((a + b) / 2.0) * 100.0;
    }

    public static Tier selectBetterTier(Tier first, Tier second) {
        if (first.getAttackDamageBonus() == second.getAttackDamageBonus()) {
            return first.getSpeed() > second.getSpeed() ? first : second;
        }
        if (first.getAttackDamageBonus() > second.getAttackDamageBonus()) {
            return first;
        }
        return second;
    }

    public static boolean isSameIngredient(Ingredient first, Ingredient second) {
        Set secondItems = Arrays.stream(second.getItems()).collect(Collectors.toSet());
        Set firstItems = Arrays.stream(first.getItems()).collect(Collectors.toSet());
        if (secondItems.size() == firstItems.size()) {
            return firstItems.containsAll(secondItems);
        }
        return false;
    }

    public static boolean isValidItem(Item item) {
        if (item.equals(Items.BARRIER)) {
            return false;
        }
        ResourceLocation identifier = BuiltInRegistries.ITEM.getKey((Object)item);
        Pattern pattern = Pattern.compile(MiapiConfig.getServerConfig().generatedMaterials.blockRegex);
        return !pattern.matcher(identifier.toString()).find() && !item.builtInRegistryHolder().is(RegistryInventory.MIAPI_FORBIDDEN_TAG);
    }

    public static boolean verboseLogging() {
        return MiapiConfig.getServerConfig().other.verboseLogging;
    }
}

