/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material.generated;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import smartin.miapi.blueprint.IngredientWithCount;
import smartin.miapi.material.CodecMaterial;
import smartin.miapi.material.generated.GeneratedMaterial;
import smartin.miapi.modules.PropertyHolder;

public class MaterialHelper {
    public static CodecMaterial toCodecMaterial(GeneratedMaterial mat) {
        Optional<JsonElement> iconJson = Optional.empty();
        if (mat.icon != null) {
            JsonObject iconObj = new JsonObject();
            iconObj.addProperty("type", "item");
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)mat.mainIngredient.getItem());
            iconObj.addProperty("item", itemId.toString());
            iconJson = Optional.of(iconObj);
        }
        JsonObject paletteObj = new JsonObject();
        paletteObj.addProperty("type", "image_generated_item");
        paletteObj.addProperty("item", mat.mainIngredient.getItem().arch$registryName().toString());
        Optional<JsonObject> paletteJson = Optional.of(paletteObj);
        Optional<JsonElement> dyePaletteJson = Optional.empty();
        ArrayList<String> groups = new ArrayList<String>(mat.getGroups());
        List<String> hiddenGroups = List.of();
        List<String> guiGroups = List.of();
        HashMap<String, JsonElement> property = new HashMap<String, JsonElement>();
        mat.properties.forEach((key, valueMap) -> property.put((String)key, (JsonElement)PropertyHolder.PROPERTY_MAP_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, valueMap).result().get()));
        Map<String, JsonElement> visualProperty = Map.of();
        Map<String, JsonElement> hiddenProperty = Map.of();
        ArrayList<String> textureKeys = new ArrayList<String>(mat.getTextureKeys());
        Optional<ResourceLocation> incorrectForToolId = Optional.empty();
        if (mat.getIncorrectBlocksForDrops() != null) {
            incorrectForToolId = Optional.of(mat.getIncorrectBlocksForDrops().location());
        }
        Optional<Component> translation = Optional.ofNullable(mat.getTranslation());
        ArrayList<IngredientWithCount> items = new ArrayList<IngredientWithCount>();
        items.add(new IngredientWithCount(Ingredient.of((ItemStack[])new ItemStack[]{mat.mainIngredient}), 1.0));
        items.add(new IngredientWithCount(mat.ingredient, 1.0));
        ArrayList<Object> toConvert = new ArrayList<Object>();
        toConvert.addAll(mat.armorItems);
        toConvert.addAll(mat.toolItems);
        CodecMaterial codec = new CodecMaterial(iconJson, paletteJson, dyePaletteJson, groups, hiddenGroups, guiGroups, property, visualProperty, hiddenProperty, textureKeys, incorrectForToolId, translation, Optional.empty(), items, (Either<Boolean, List<Holder<Item>>>)Either.right(toConvert.stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).wrapAsHolder(arg_0)).toList()), List.of());
        codec.doubleMap = new HashMap<String, Double>(mat.stats);
        return codec;
    }
}

