/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material.palette;

import com.google.gson.JsonElement;
import com.redpxnda.nucleus.util.Color;
import java.util.HashMap;
import java.util.Map;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.palette.GrayscalePaletteColorer;
import smartin.miapi.material.palette.MaskColorer;
import smartin.miapi.material.palette.MaterialRenderController;
import smartin.miapi.material.palette.PaletteAtlasBackedColorer;
import smartin.miapi.material.palette.SpriteOverlayer;

@OnlyIn(value=Dist.CLIENT)
public class MaterialRenderControllers {
    public static final Map<String, RenderControllerCreator> creators = new HashMap<String, RenderControllerCreator>();
    public static final Map<String, FillerFunction> fillers = new HashMap<String, FillerFunction>();
    public static FillerFunction interpolateFiller;

    public static void setup() {
        interpolateFiller = (last, current, next, lX, cX, nX, placer) -> {
            for (int i = lX; i < cX; ++i) {
                float delta = (float)(i - lX) / (float)(cX - lX);
                Color col = new Color();
                last.lerp(delta, current, col);
                placer.place(col, i, 0);
            }
        };
        fillers.put("interpolate", interpolateFiller);
        fillers.put("current_to_last", (last, current, next, lX, cX, nX, placer) -> {
            for (int i = lX; i < cX; ++i) {
                placer.place(current, i, 0);
            }
        });
        fillers.put("last_to_current", (last, current, next, lX, cX, nX, placer) -> {
            for (int i = lX; i < cX; ++i) {
                placer.place(last, i, 0);
            }
        });
        fillers.put("current_last_shared", (last, current, next, lX, cX, nX, placer) -> {
            for (int i = lX; i < cX; ++i) {
                float delta = (float)(i - lX) / (float)(cX - lX);
                Color color = (double)delta < 0.5 ? last : current;
                placer.place(color, i, 0);
            }
        });
        creators.put("grayscale_map", (json, material) -> new GrayscalePaletteColorer(material, json));
        creators.put("overlay_texture", (json, material) -> new SpriteOverlayer(material, json));
        creators.put("image_generated", (json, material) -> GrayscalePaletteColorer.createForImageJson(material, json, false));
        creators.put("image_generated_item", (json, material) -> GrayscalePaletteColorer.createForImageJson(material, json, true));
        creators.put("image_generated_tag", (json, material) -> GrayscalePaletteColorer.createForImageJson(material, json));
        creators.put("from_material_palette_image", (json, material) -> PaletteAtlasBackedColorer.createColorer(material, json));
        creators.put("layered_mask", (json, material) -> MaskColorer.fromJson(material, json));
    }

    public static interface FillerFunction {
        public void fill(Color var1, Color var2, Color var3, int var4, int var5, int var6, PixelPlacer var7);
    }

    public static interface RenderControllerCreator {
        public MaterialRenderController createPalette(JsonElement var1, Material var2);
    }

    public static interface PixelPlacer {
        public void place(Color var1, int var2, int var3);
    }
}

