/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material.palette;

import com.google.gson.JsonElement;
import com.mojang.blaze3d.platform.NativeImage;
import com.redpxnda.nucleus.util.Color;
import java.util.ArrayList;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.client.MiapiClient;
import smartin.miapi.client.atlas.MaterialSpriteManager;
import smartin.miapi.client.renderer.NativeImageGetter;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.palette.FallbackColorer;
import smartin.miapi.material.palette.SpritePixelReplacer;

@OnlyIn(value=Dist.CLIENT)
public class PaletteAtlasBackedColorer
extends SpritePixelReplacer {
    protected ResourceLocation spriteId = Material.BASE_PALETTE_ID;
    protected Color averageColor;
    protected boolean isAnimated = false;
    protected NativeImageGetter.ImageHolder image;
    protected SpriteContents contents;

    protected PaletteAtlasBackedColorer(Material material) {
        super(material);
    }

    public PaletteAtlasBackedColorer(Material material, ResourceLocation id) {
        super(material);
        this.setupSprite(id);
    }

    public PaletteAtlasBackedColorer(Material material, JsonElement json) {
        super(material);
        ResourceLocation id = ResourceLocation.parse((String)json.getAsJsonObject().get("location").getAsString());
        this.setupSprite(id);
    }

    public static SpritePixelReplacer createColorer(Material material, JsonElement json) {
        PaletteAtlasBackedColorer colorer = new PaletteAtlasBackedColorer(material, json);
        TextureAtlasSprite sprite = MiapiClient.materialAtlasManager.getMaterialSprite(colorer.getSpriteId());
        if (sprite == null) {
            Miapi.LOGGER.error("could not locate sprite " + String.valueOf(colorer.spriteId));
            return new FallbackColorer(material);
        }
        if (sprite.contents().width() < 255) {
            Miapi.LOGGER.error("loaded sprite does not have the right dimmensions! It needs a width of 255" + sprite.contents().width());
            return new FallbackColorer(material);
        }
        return colorer;
    }

    @Override
    public int getReplacementColor(int pixelX, int pixelY, int previousAbgr) {
        int red = FastColor.ABGR32.red((int)previousAbgr);
        return this.image.getColor(Mth.clamp((int)red, (int)0, (int)255), 0);
    }

    public void setupSprite(ResourceLocation id) {
        this.spriteId = id;
        TextureAtlasSprite sprite = MiapiClient.materialAtlasManager.getMaterialSprite(this.getSpriteId());
        this.contents = sprite.contents();
        this.isAnimated = this.isAnimatedSprite(this.contents);
    }

    @Nullable
    public ResourceLocation getSpriteId() {
        return this.spriteId;
    }

    @Override
    public boolean doTick() {
        return this.isAnimated;
    }

    @Override
    public NativeImage transform(SpriteContents originalSprite) {
        if (this.contents == null) {
            TextureAtlasSprite sprite = MiapiClient.materialAtlasManager.getMaterialSprite(this.getSpriteId());
            if (sprite != null) {
                MaterialSpriteManager.markTextureAsAnimatedInUse(sprite);
                this.contents = sprite.contents();
            } else {
                this.contents = originalSprite;
            }
        }
        this.image = NativeImageGetter.get(this.contents);
        NativeImage result = super.transform(originalSprite);
        this.image = null;
        return result;
    }

    @Override
    public Color getAverageColor() {
        if (this.averageColor == null) {
            TextureAtlasSprite sprite = MiapiClient.materialAtlasManager.getMaterialSprite(this.spriteId);
            if (sprite == null) {
                return Color.WHITE;
            }
            NativeImage img = NativeImageGetter.getImage(sprite.contents());
            ArrayList<Color> colors = new ArrayList<Color>();
            int height = img.getHeight();
            int width = img.getWidth();
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    int color = img.getPixelRGBA(x, y);
                    colors.add(new Color(FastColor.ABGR32.red((int)color), FastColor.ABGR32.green((int)color), FastColor.ABGR32.blue((int)color), FastColor.ABGR32.alpha((int)color)));
                }
            }
            int red = 0;
            int green = 0;
            int blue = 0;
            int alpha = 0;
            for (Color color : colors) {
                if (color.a() <= 0) continue;
                red += color.r();
                green += color.g();
                blue += color.b();
                alpha += color.a();
            }
            this.averageColor = new Color(red / colors.size(), green / colors.size(), blue / colors.size(), alpha / colors.size());
        }
        return this.averageColor;
    }
}

