/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material.palette;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.SpriteTicker;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.client.atlas.MaterialSpriteManager;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.palette.MaterialRenderController;
import smartin.miapi.modules.ModuleInstance;

@OnlyIn(value=Dist.CLIENT)
public abstract class SpriteColorer
implements MaterialRenderController {
    protected static Map<TextureAtlasSprite, VertexConsumer> lookupMap = new WeakHashMap<TextureAtlasSprite, VertexConsumer>();
    public Material material;

    public SpriteColorer(Material material) {
        this.material = material;
    }

    public MaterialRecoloredSpriteHolder createSpriteManager(SpriteContents spriteContents) {
        return new MaterialRecoloredSpriteHolder(spriteContents);
    }

    public void tick(Consumer<NativeImage> nativeImageConsumer, SpriteContents spriteContents) {
        nativeImageConsumer.accept(this.transform(spriteContents));
    }

    public abstract NativeImage transform(SpriteContents var1);

    public abstract boolean doTick();

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public VertexConsumer getVertexConsumer(MultiBufferSource vertexConsumers, TextureAtlasSprite originalSprite, ItemStack stack, ModuleInstance moduleInstance, ItemDisplayContext mode) {
        return MaterialSpriteManager.getVertexConsumer(vertexConsumers, originalSprite, this.material, this);
    }

    public boolean isAnimatedSprite(SpriteContents spriteContents) {
        return SpriteColorer.isAnimatedSpriteStatic(spriteContents);
    }

    public static boolean isAnimatedSpriteStatic(SpriteContents spriteContents) {
        try (SpriteTicker animator = spriteContents.createTicker();){
            if (animator != null) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public class MaterialRecoloredSpriteHolder {
        SpriteContents lastRecolouredSprite;
        boolean isAnimated;

        public MaterialRecoloredSpriteHolder(SpriteContents modelSprite) {
            this.lastRecolouredSprite = modelSprite;
            this.isAnimated = SpriteColorer.this.isAnimatedSprite(modelSprite);
        }

        public boolean requireTick() {
            return this.isAnimated || SpriteColorer.this.doTick();
        }

        public Material getMaterial() {
            return SpriteColorer.this.material;
        }

        public NativeImage recolor() {
            return SpriteColorer.this.transform(this.lastRecolouredSprite);
        }

        public boolean equals(Object obj) {
            if (obj instanceof MaterialRecoloredSpriteHolder) {
                MaterialRecoloredSpriteHolder other = (MaterialRecoloredSpriteHolder)obj;
                return other.lastRecolouredSprite.equals(this.lastRecolouredSprite) && SpriteColorer.this.material.equals(other.getMaterial());
            }
            return super.equals(obj);
        }
    }
}

