/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material.palette;

import com.google.gson.JsonElement;
import com.mojang.blaze3d.platform.NativeImage;
import com.redpxnda.nucleus.util.Color;
import java.util.function.Consumer;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.client.AnimatedTexturesManager;
import smartin.miapi.client.renderer.NativeImageGetter;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.palette.SpriteFromJson;
import smartin.miapi.material.palette.SpritePixelReplacer;

@OnlyIn(value=Dist.CLIENT)
public class SpriteOverlayer
extends SpritePixelReplacer {
    public final Color averageColor;
    public final SpriteFromJson delegate;
    protected NativeImageGetter.ImageHolder overlayImage;

    public SpriteOverlayer(Material material, JsonElement json) {
        super(material);
        this.delegate = SpriteFromJson.getFromJson(json);
        this.averageColor = this.delegate.getAverageColor();
    }

    @Override
    public void tick(Consumer<NativeImage> nativeImageConsumer, SpriteContents spriteContents) {
        super.tick(nativeImageConsumer, spriteContents);
        AnimatedTexturesManager.markAnimated(this.delegate.rawSprite);
    }

    @Override
    public Color getAverageColor() {
        return this.averageColor;
    }

    @Override
    public int getReplacementColor(int x, int y, int previousAbgr) {
        int abgr = this.overlayImage.getColor(x % this.overlayImage.getWidth(), y % this.overlayImage.getHeight());
        int alpha = FastColor.ABGR32.alpha((int)abgr);
        if (alpha != 255) {
            float overlayA = (float)alpha / 255.0f;
            int overlayR = FastColor.ABGR32.red((int)abgr);
            int overlayG = FastColor.ABGR32.green((int)abgr);
            int overlayB = FastColor.ABGR32.blue((int)abgr);
            float baseA = (float)FastColor.ABGR32.alpha((int)previousAbgr) / 255.0f;
            int baseR = FastColor.ABGR32.red((int)previousAbgr);
            int baseG = FastColor.ABGR32.green((int)previousAbgr);
            int baseB = FastColor.ABGR32.blue((int)previousAbgr);
            int newR = Mth.lerpInt((float)overlayA, (int)baseR, (int)overlayR);
            int newG = Mth.lerpInt((float)overlayA, (int)baseG, (int)overlayG);
            int newB = Mth.lerpInt((float)overlayA, (int)baseB, (int)overlayB);
            int newA = (int)(Mth.lerp((float)baseA, (float)overlayA, (float)1.0f) * 255.0f);
            return FastColor.ABGR32.color((int)newA, (int)newB, (int)newG, (int)newR);
        }
        return abgr;
    }

    @Override
    public NativeImage transform(SpriteContents sprite) {
        this.overlayImage = this.delegate.getNativeImage();
        this.delegate.markUse();
        NativeImage result = super.transform(sprite);
        this.overlayImage = null;
        return result;
    }

    @Override
    public boolean doTick() {
        return this.delegate.isAnimated();
    }
}

