/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.mixin;

import java.util.Map;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import smartin.miapi.attributes.ElytraAttributes;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.registries.RegistryInventory;

@Mixin(value={LivingEntity.class})
abstract class LivingEntityMixin {
    LivingEntityMixin() {
    }

    @Inject(method={"collectEquipmentChanges()Ljava/util/Map;"}, at={@At(value="RETURN")})
    private void miapi$enEquipChange(CallbackInfoReturnable<Map<EquipmentSlot, ItemStack>> cir) {
        LivingEntity player = (LivingEntity)this;
        if (player instanceof Player) {
            Player entity = (Player)player;
            Map map = (Map)cir.getReturnValue();
            if (map != null && !map.isEmpty()) {
                ((MiapiEvents.PlayerEquip)MiapiEvents.PLAYER_EQUIP_EVENT.invoker()).equip(entity, map);
            }
        }
    }

    @Inject(method={"randomTeleport(DDDZ)Z"}, at={@At(value="HEAD")})
    private void miapi$optionalTeleportBlockEffect(double x, double y, double z, boolean broadcastTeleport, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity entity = (LivingEntity)this;
        if (broadcastTeleport && MiapiConfig.getServerConfig().other.blockAllTeleportsEffect && entity.hasEffect(RegistryInventory.teleportBlockEffect)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    private void miapi$adjustElytraSpeed(CallbackInfo ci) {
        LivingEntity livingEntity = (LivingEntity)this;
        ElytraAttributes.movementUpdate(livingEntity);
        ((MiapiEvents.LivingEntityTickEvent)MiapiEvents.LIVING_ENTITY_TICK_END.invoker()).tick(livingEntity);
    }
}

