/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.mixin;

import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.registries.RegistryInventory;

@Mixin(value={Mob.class})
public class MobMixin {
    @Inject(method={"serverAiStep()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void miapi$stopMovementTick(CallbackInfo ci) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity.hasEffect(RegistryInventory.stunEffect)) {
            MobEffectInstance active = livingEntity.getEffect(RegistryInventory.stunEffect);
            if (active != null && active.endsWithin(1)) {
                livingEntity.removeEffect(RegistryInventory.stunEffect);
                livingEntity.addEffect(new MobEffectInstance(RegistryInventory.stunResistanceEffect, MiapiConfig.getServerConfig().stunEffectCategory.stunResistanceLength), (Entity)livingEntity);
            }
            if (livingEntity instanceof Player) {
                Player playerEntity = (Player)livingEntity;
                if (!playerEntity.hasEffect(MobEffects.BLINDNESS)) {
                    // empty if block
                }
            } else {
                if (livingEntity instanceof Mob) {
                    Mob mob = (Mob)livingEntity;
                    mob.setSpeed(0.0f);
                }
                ci.cancel();
            }
        }
        if (livingEntity.hasEffect(RegistryInventory.cryoStatusEffect) && livingEntity instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            mob.setSpeed(0.0f);
        }
    }
}

