/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.mixin.enchant;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.item.modular.ModularItem;

@Mixin(value={EnchantmentHelper.class})
public abstract class EnchantmentHelperMixin {
    @Inject(method={"Lnet/minecraft/world/item/enchantment/EnchantmentHelper;processDurabilityChange(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/item/ItemStack;I)I"}, at={@At(value="RETURN")})
    private static void afterModifyEnchantments(ServerLevel level, ItemStack stack, int damage, CallbackInfoReturnable<Integer> cir) {
        if (ModularItem.isModularItem(stack)) {
            ((MiapiEvents.DurabilityEvent)MiapiEvents.MODULAR_ITEM_DAMAGE.invoker()).durability(damage, stack, level);
        }
    }

    @WrapOperation(method={"runIterationOnItem(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/EquipmentSlot;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/enchantment/EnchantmentHelper$EnchantmentInSlotVisitor;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;get(Lnet/minecraft/core/component/DataComponentType;)Ljava/lang/Object;")})
    private static Object wrapGetEnchantments(ItemStack stack, DataComponentType<?> type, Operation<Object> original, ItemStack callStack, EquipmentSlot slot, LivingEntity entity) {
        Object real = original.call(new Object[]{stack, type});
        if (type == DataComponents.ENCHANTMENTS && real == null && ModularItem.isModularItem(stack)) {
            return ItemEnchantments.EMPTY;
        }
        return real;
    }

    @WrapOperation(method={"runIterationOnItem(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/EquipmentSlot;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/enchantment/EnchantmentHelper$EnchantmentInSlotVisitor;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/enchantment/ItemEnchantments;isEmpty()Z")})
    private static boolean wrapIsEmpty(ItemEnchantments self, Operation<Boolean> original, ItemStack stack, EquipmentSlot slot, LivingEntity entity) {
        boolean vanillaEmpty = (Boolean)original.call(new Object[]{self});
        if (vanillaEmpty && ModularItem.isModularItem(stack)) {
            return false;
        }
        return vanillaEmpty;
    }
}

