/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.mixin.enchant;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.modules.properties.enchanment.AllowedEnchantments;

@Mixin(value={Enchantment.class})
public abstract class EnchantmentMixin {
    @ModifyReturnValue(method={"isPrimaryItem(Lnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="RETURN")})
    private boolean miapi$adjustPrimaryItem(boolean original, ItemStack itemStack) {
        if (ModularItem.isModularItem(itemStack)) {
            Enchantment enchantment = (Enchantment)this;
            return AllowedEnchantments.canEnchant(itemStack, enchantment, original);
        }
        return original;
    }

    @ModifyReturnValue(method={"isSupportedItem(Lnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="RETURN")})
    private boolean miapi$adjustSupportedItem(boolean original, ItemStack itemStack) {
        if (ModularItem.isModularItem(itemStack)) {
            Enchantment enchantment = (Enchantment)this;
            return AllowedEnchantments.isSupported(itemStack, enchantment, original);
        }
        return original;
    }

    @Unique
    @OnlyIn(value=Dist.CLIENT)
    public Holder<Enchantment> getClient(Enchantment enchantment) {
        return ((Registry)Minecraft.getInstance().level.registryAccess().registry(Registries.ENCHANTMENT).get()).wrapAsHolder((Object)enchantment);
    }

    @ModifyReturnValue(method={"canEnchant(Lnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="RETURN")})
    private boolean miapi$adjustcanEnchant(boolean original, ItemStack itemStack) {
        if (ModularItem.isModularItem(itemStack)) {
            Enchantment enchantment = (Enchantment)this;
            return AllowedEnchantments.canEnchant(itemStack, enchantment, original);
        }
        return original;
    }
}

