/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.mixin.item;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import smartin.miapi.MixinContextFlags;
import smartin.miapi.client.gui.crafting.PreviewManager;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.item.FakeItemManager;
import smartin.miapi.item.ModularItemStackConverter;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.item.modular.VisualModularItem;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.properties.AssumeItemIdentityProperty;
import smartin.miapi.modules.properties.FakeItemTagProperty;
import smartin.miapi.modules.properties.LoreProperty;
import smartin.miapi.modules.properties.enchanment.FakeEnchantmentManager;
import smartin.miapi.registries.RegistryInventory;

@Mixin(value={ItemStack.class}, priority=2000)
public abstract class MiapiItemStackMixin {
    @Shadow
    public abstract void releaseUsing(Level var1, LivingEntity var2, int var3);

    @Shadow
    public abstract boolean is(Item var1);

    @ModifyReturnValue(method={"is(Lnet/minecraft/tags/TagKey;)Z"}, at={@At(value="RETURN")})
    public boolean miapi$injectItemTag(boolean original, TagKey<Item> tag) {
        ItemStack stack = (ItemStack)this;
        if (ModularItem.isModularItem(stack) && !original) {
            return FakeItemTagProperty.hasTag(tag.location(), stack);
        }
        return original;
    }

    @Inject(method={"Lnet/minecraft/world/item/ItemStack;getItemHolder()Lnet/minecraft/core/Holder;"}, at={@At(value="HEAD")})
    public void miapi$preventItem(CallbackInfoReturnable<Item> cir) {
    }

    @Inject(method={"getItem()Lnet/minecraft/world/item/Item;"}, at={@At(value="TAIL")})
    public void miapi$capturePotentialItemstack(CallbackInfoReturnable<Item> cir) {
        ItemStack stack = (ItemStack)this;
        if (ModularItem.isModularItem(stack, (Item)cir.getReturnValue())) {
            FakeItemManager.getItemCall(stack, (Item)cir.getReturnValue());
        }
    }

    @ModifyReturnValue(method={"getItem()Lnet/minecraft/world/item/Item;"}, at={@At(value="RETURN")})
    public Item miapi$adjustIsItem(Item original) {
        ThreadLocal<Map<ItemStack, Item>> a;
        Item fake;
        ItemStack stack = (ItemStack)this;
        if (ModularItem.isModularItem(stack, original) && (fake = (a = MixinContextFlags.IGNORE_NEXT_GET_ITEM_CALL).get().get(stack)) != null) {
            return fake;
        }
        return original;
    }

    @Inject(method={"copy()Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="RETURN")})
    public void miapi$keepLookupOnCopy(CallbackInfoReturnable<ItemStack> cir) {
        ItemStack stack = (ItemStack)this;
        if (ModularItemStackConverter.lookupMap.containsKey(stack)) {
            ModularItemStackConverter.lookupMap.put((ItemStack)cir.getReturnValue(), ModularItemStackConverter.lookupMap.get(stack));
        }
    }

    @ModifyReturnValue(method={"is(Lnet/minecraft/world/item/Item;)Z"}, at={@At(value="RETURN")})
    public boolean miapi$adjustIsItem(boolean original, Item item) {
        ItemStack stack = (ItemStack)this;
        if (item != null && !original && ModularItem.isModularItem(stack)) {
            Optional<List> property = AssumeItemIdentityProperty.property.getData(stack);
            Optional<Boolean> match = property.map(a -> a.stream().anyMatch(h -> ((Item)h.value()).equals(item)));
            return match.orElse(original);
        }
        return original;
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/ItemLike;ILnet/minecraft/core/component/PatchedDataComponentMap;)V"}, at={@At(value="RETURN")})
    public void miapi$capturePotentialItemstack(ItemLike item, int count, PatchedDataComponentMap components, CallbackInfo ci) {
        ItemStack stack = (ItemStack)this;
        if (ModularItem.isModularItem(stack, item.asItem())) {
            FakeEnchantmentManager.initOnItemStack(stack);
        }
    }

    @Inject(method={"addToTooltip(Lnet/minecraft/core/component/DataComponentType;Lnet/minecraft/world/item/Item$TooltipContext;Ljava/util/function/Consumer;Lnet/minecraft/world/item/TooltipFlag;)V"}, at={@At(value="TAIL")})
    public <T> void miapi$injectToolTip(DataComponentType<T> component, Item.TooltipContext context, Consumer<Component> tooltipAdder, TooltipFlag tooltipFlag, CallbackInfo ci) {
        ItemStack stack = (ItemStack)this;
        PreviewManager.setCursorItemstack(stack);
        if (DataComponents.UNBREAKABLE.equals(component)) {
            FakeEnchantmentManager.initOnItemStack(stack);
            if (VisualModularItem.isVisualModularItem(stack)) {
                ArrayList<Component> lore = new ArrayList<Component>();
                LoreProperty.property.appendLoreBottom(lore, stack);
                lore.forEach(tooltipAdder);
            } else {
                ArrayList<Component> lore = new ArrayList<Component>();
                LoreProperty.property.injectTooltipOnNonModularItems(lore, stack);
                lore.forEach(tooltipAdder);
            }
        }
    }

    @Inject(method={"hurtAndBreak(ILnet/minecraft/server/level/ServerLevel;Lnet/minecraft/server/level/ServerPlayer;Ljava/util/function/Consumer;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void miapi$preventFullBreak(int damage, ServerLevel level, ServerPlayer player, Consumer<Item> onBreak, CallbackInfo ci) {
        ItemStack current = (ItemStack)this;
        if (ModularItem.isModularItem(current) && current.isDamageableItem() && !MiapiConfig.getServerConfig().other.fullBreakModularItems && player != null && !player.hasInfiniteMaterials() && damage + current.getDamageValue() >= current.getMaxDamage()) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (!player.getItemBySlot(slot).equals(current)) continue;
                ItemStack broken = new ItemStack((ItemLike)RegistryInventory.brokenModualrItem);
                ItemModule.getModules(current).writeToItem(broken);
                broken.set(DataComponents.DAMAGE, (Object)((Integer)current.get(DataComponents.DAMAGE)));
                broken.set(DataComponents.MAX_DAMAGE, (Object)((Integer)current.get(DataComponents.MAX_DAMAGE)));
                player.setItemSlot(slot, broken);
                ci.cancel();
            }
        }
    }

    @Inject(method={"hurtAndBreak(ILnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/entity/EquipmentSlot;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public <T> void miapi$preventFullBreak(int amount, LivingEntity entity, EquipmentSlot slot, CallbackInfo ci) {
        ItemStack current = (ItemStack)this;
        if (ModularItem.isModularItem(current) && current.isDamageableItem() && !MiapiConfig.getServerConfig().other.fullBreakModularItems && entity != null && !entity.hasInfiniteMaterials() && amount + current.getDamageValue() >= current.getMaxDamage()) {
            ItemStack broken = new ItemStack((ItemLike)RegistryInventory.brokenModualrItem);
            ItemModule.getModules(current).writeToItem(broken);
            broken.set(DataComponents.DAMAGE, (Object)((Integer)current.get(DataComponents.DAMAGE)));
            broken.set(DataComponents.MAX_DAMAGE, (Object)((Integer)current.get(DataComponents.MAX_DAMAGE)));
            entity.setItemSlot(slot, broken);
            ci.cancel();
        }
    }
}

