/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.mixin.projectile;

import com.mojang.serialization.DynamicOps;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import smartin.miapi.Miapi;
import smartin.miapi.entity.ProjectileWithBow;

@Mixin(value={Projectile.class})
public class ProjectileMixin
implements ProjectileWithBow {
    private static final String MIAPI_SHOW_BY_BOW = "miapi:show_by_bow";
    private static final EntityDataAccessor<ItemStack> asd = ProjectileWithBow.get();

    @Inject(method={"Lnet/minecraft/world/entity/projectile/Projectile;readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="HEAD")})
    private void miapi$readBowItem(CompoundTag compound, CallbackInfo ci) {
        if (compound.contains(MIAPI_SHOW_BY_BOW)) {
            try {
                Projectile p = (Projectile)this;
                RegistryOps ops = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)p.level().registryAccess());
                this.setBowItem(ItemStack.CODEC.parse((DynamicOps)ops, (Object)compound.get(MIAPI_SHOW_BY_BOW)).resultOrPartial(msg -> Miapi.LOGGER.warn("Failed to parse bow ItemStack: {}", msg)).orElse(ItemStack.EMPTY));
            }
            catch (RuntimeException e) {
                Miapi.LOGGER.warn("Could not decode bow stack on arrow", (Throwable)e);
            }
        }
    }

    @Inject(method={"Lnet/minecraft/world/entity/projectile/Projectile;addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="HEAD")})
    private void miapi$addBowItem(CompoundTag compound, CallbackInfo ci) {
        ItemStack miapiBowStack = this.getBowItem();
        if (miapiBowStack != null && !miapiBowStack.isEmpty()) {
            try {
                Projectile p = (Projectile)this;
                compound.put(MIAPI_SHOW_BY_BOW, (Tag)ItemStack.CODEC.encodeStart((DynamicOps)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)p.level().registryAccess()), (Object)this.getBowItem()).getOrThrow(msg -> new RuntimeException("Failed to encode bow ItemStack: {}")));
            }
            catch (RuntimeException e) {
                Miapi.LOGGER.warn("Could not encode bow stack on arrow", (Throwable)e);
            }
        }
    }

    @Override
    @Unique
    public ItemStack getBowItem() {
        Projectile p = (Projectile)this;
        return (ItemStack)p.getEntityData().get(ProjectileWithBow.get());
    }

    @Override
    @Unique
    public void setBowItem(ItemStack bowItem) {
        Projectile p = (Projectile)this;
        p.getEntityData().set(ProjectileWithBow.get(), (Object)bowItem);
    }
}

