/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.entity.player.Player;
import smartin.miapi.Miapi;
import smartin.miapi.config.MiapiConfig;

public class MiapiPermissions {
    static HttpClient httpClient = HttpClient.newHttpClient();
    static Map<UUID, List<String>> playerPerms = new ConcurrentHashMap<UUID, List<String>>();
    static Set<UUID> loadingPerms = Collections.newSetFromMap(new ConcurrentHashMap());

    public static boolean hasPerm(Player player, String perm) {
        if (MiapiConfig.getServerConfig().other.developmentMode) {
            return true;
        }
        if (perm.equals(player.getUUID().toString())) {
            return true;
        }
        List<String> perms = MiapiPermissions.getPerms(player);
        return perms.contains(perm) || perms.contains("broken");
    }

    public static boolean hasPerm(Player player, List<String> perms) {
        for (String perm : perms) {
            if (!MiapiPermissions.hasPerm(player, perm)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getPerms(Player player) {
        UUID uuid = player.getUUID();
        if (playerPerms.containsKey(uuid)) {
            return playerPerms.get(uuid);
        }
        ArrayList<String> defaultPerms = new ArrayList<String>(List.of("user"));
        playerPerms.put(uuid, defaultPerms);
        if (!loadingPerms.contains(uuid)) {
            loadingPerms.add(uuid);
            MiapiPermissions.fetchPermissionsAsync(uuid);
        }
        return defaultPerms;
    }

    private static void fetchPermissionsAsync(UUID playerUUID) {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("http://trulymodular.dedyn.io:3000/perms/" + String.valueOf(playerUUID))).GET().build();
        ((CompletableFuture)((CompletableFuture)httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body)).thenAccept(responseBody -> {
            try {
                PermissionJson perms = (PermissionJson)Miapi.gson.fromJson(responseBody, PermissionJson.class);
                if (perms != null && perms.permissions != null) {
                    perms.permissions.add("user");
                    playerPerms.put(playerUUID, perms.permissions);
                } else {
                    playerPerms.put(playerUUID, new ArrayList<String>(List.of("broken", "user")));
                }
            }
            catch (Exception e) {
                Miapi.LOGGER.warn("Failed to parse Miapi Permissions for UUID " + String.valueOf(playerUUID), (Throwable)e);
                playerPerms.put(playerUUID, new ArrayList<String>(List.of("broken", "user")));
            }
            finally {
                loadingPerms.remove(playerUUID);
            }
        })).exceptionally(e -> {
            Miapi.LOGGER.warn("Could not retrieve Miapi Permissions for UUID " + String.valueOf(playerUUID), e);
            playerPerms.put(playerUUID, new ArrayList<String>(List.of("broken", "user")));
            loadingPerms.remove(playerUUID);
            return null;
        });
    }

    private static class PermissionJson {
        public String uuid;
        public List<String> permissions;

        private PermissionJson() {
        }
    }
}

