/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.handler.codec.DecoderException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import smartin.miapi.Miapi;
import smartin.miapi.item.modular.PropertyResolver;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.ModuleProperty;
import smartin.miapi.registries.RegistryInventory;

public class PropertyHolder {
    public static final Codec<ModuleProperty<?>> PROPERTY_CODEC = Miapi.ID_CODEC.xmap(r -> {
        ModuleProperty p = RegistryInventory.MODULE_PROPERTY_MIAPI_REGISTRY.get((ResourceLocation)r);
        if (p == null) {
            throw new RuntimeException((Throwable)new DecoderException("Could not find property for key: " + String.valueOf(r)));
        }
        return p;
    }, property -> {
        ResourceLocation key = RegistryInventory.MODULE_PROPERTY_MIAPI_REGISTRY.findKey((ModuleProperty)property);
        if (key == null) {
            throw new RuntimeException("Could not find registry key for property: " + String.valueOf(property));
        }
        return key;
    });
    public static final Codec<Map<ModuleProperty<?>, Object>> PROPERTY_MAP_CODEC = Codec.dispatchedMap(PROPERTY_CODEC, a -> {
        if (a == null) {
            throw new IllegalArgumentException("ModuleProperty codec (a) must not be null");
        }
        return StatResolver.Codecs.JSONELEMENT_CODEC.xmap(json -> {
            try {
                if (json == null) {
                    throw new IllegalArgumentException("JSON element to decode is null");
                }
                return a.decodeAndLoad((JsonElement)json);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Failed to decode and load JSON for property: " + String.valueOf(a), e);
            }
        }, obj -> {
            try {
                if (obj == null) {
                    throw new IllegalArgumentException("Object to encode is null");
                }
                return a.encodeCast(obj);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Failed to encode object for property: " + String.valueOf(a), e);
            }
        });
    });
    public static final MapCodec<PropertyHolder> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PROPERTY_MAP_CODEC.optionalFieldOf("replace", new HashMap()).forGetter(PropertyHolder::getReplace), (App)PROPERTY_MAP_CODEC.optionalFieldOf("merge", new HashMap()).forGetter(PropertyHolder::getMerge), (App)Codec.list(PROPERTY_CODEC).optionalFieldOf("remove", new ArrayList()).forGetter(PropertyHolder::getRemove)).apply((Applicative)instance, PropertyHolder::new));
    private final Map<ModuleProperty<?>, Object> replace;
    private final Map<ModuleProperty<?>, Object> merge;
    private final List<ModuleProperty<?>> remove;

    public PropertyHolder() {
        this(new HashMap(), new HashMap(), new ArrayList());
    }

    public PropertyHolder(Map<ModuleProperty<?>, Object> replace, Map<ModuleProperty<?>, Object> merge, List<ModuleProperty<?>> remove) {
        this.replace = replace;
        this.merge = merge;
        this.remove = remove;
    }

    public void load(ResourceLocation id) {
        this.replace.forEach((p, data) -> {
            try {
                p.load(id, p.encodeCast(data), true);
            }
            catch (RuntimeException runtimeException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public Map<ModuleProperty<?>, Object> getReplace() {
        return this.replace;
    }

    public Map<ModuleProperty<?>, Object> getMerge() {
        return this.merge;
    }

    public List<ModuleProperty<?>> getRemove() {
        return this.remove;
    }

    public Map<ModuleProperty<?>, Object> applyHolder(Map<ModuleProperty<?>, Object> oldMap, Optional<Component> component) {
        this.remove.forEach(oldMap::remove);
        PropertyResolver.setSource(this.merge, component).forEach((key, value) -> {
            if (oldMap.containsKey(key)) {
                oldMap.put((ModuleProperty<?>)key, ItemModule.merge(key, oldMap.get(key), value, MergeType.SMART));
            } else {
                oldMap.put((ModuleProperty<?>)key, value);
            }
        });
        oldMap.putAll(PropertyResolver.setSource(this.replace, component));
        return oldMap;
    }
}

