/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities;

import com.mojang.serialization.MapCodec;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.abilities.util.MinMaxCDAbility;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

public class AreaHarvestReplant
extends MinMaxCDAbility<AreaHarvestJson> {
    public static String KEY = "area_harvest_ability";
    public static MapCodec<AreaHarvestJson> CODEC = AutoCodec.of(AreaHarvestJson.class);

    public AreaHarvestReplant() {
        super(0, 0);
    }

    @Override
    public boolean allowedOnItem(ItemStack itemStack, Level world, Player player, InteractionHand hand, ItemAbilityManager.AbilityHitContext abilityHitContext, MinMaxCDAbility.MinMaxCDData<AreaHarvestJson> context) {
        if (abilityHitContext.hitEntity() == null && abilityHitContext.hitResult() != null) {
            BlockState state = abilityHitContext.hitResult().getLevel().getBlockState(abilityHitContext.hitResult().getClickedPos());
            return this.isGrown(state);
        }
        return false;
    }

    public boolean isGrown(BlockState state) {
        Block block = state.getBlock();
        if (block instanceof CropBlock) {
            CropBlock cropBlock = (CropBlock)block;
            return cropBlock.isMaxAge(state);
        }
        return false;
    }

    @Override
    public UseAnim getUseAction(ItemStack itemStack, MinMaxCDAbility.MinMaxCDData<AreaHarvestJson> context) {
        return UseAnim.BRUSH;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand, MinMaxCDAbility.MinMaxCDData<AreaHarvestJson> context) {
        return null;
    }

    @Override
    public InteractionResult useOnBlock(UseOnContext context, MinMaxCDAbility.MinMaxCDData<AreaHarvestJson> abilityContext) {
        Player player;
        ItemStack itemStack = context.getItemInHand();
        if (!context.getLevel().isClientSide() && (player = context.getPlayer()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            int blocksHarvested = 0;
            int range = (int)abilityContext.data().range.evaluate(0.0, 1.0);
            BlockState state = context.getLevel().getBlockState(context.getClickedPos());
            BlockPos origin = context.getClickedPos();
            if (this.isGrown(state)) {
                for (int x = -range; x <= range; ++x) {
                    for (int y = -range; y <= range; ++y) {
                        Block block;
                        BlockPos currentPos = origin.offset(x, 0, y);
                        BlockState blockState = context.getLevel().getBlockState(currentPos);
                        if (!this.isGrown(blockState) || !((block = blockState.getBlock()) instanceof CropBlock)) continue;
                        CropBlock cropBlock = (CropBlock)block;
                        block = context.getLevel();
                        if (!(block instanceof ServerLevel)) continue;
                        ServerLevel serverWorld = (ServerLevel)block;
                        BlockEntity blockEntity = blockState.hasBlockEntity() ? context.getLevel().getBlockEntity(currentPos) : null;
                        List stacks = Block.getDrops((BlockState)blockState, (ServerLevel)serverWorld, (BlockPos)currentPos, (BlockEntity)blockEntity, (Entity)serverPlayer, (ItemStack)itemStack);
                        serverWorld.setBlockAndUpdate(currentPos, cropBlock.getStateForAge(0));
                        stacks.forEach(arg_0 -> ((ServerPlayer)serverPlayer).spawnAtLocation(arg_0));
                        ++blocksHarvested;
                    }
                }
            }
            itemStack.hurtAndBreak(blocksHarvested, (LivingEntity)serverPlayer, this.getEquipmentSlot(context.getHand()));
            return InteractionResult.sidedSuccess((boolean)context.getLevel().isClientSide());
        }
        return InteractionResult.FAIL;
    }

    @Override
    protected AreaHarvestJson mergeData(AreaHarvestJson left, AreaHarvestJson right, MergeType mergeType) {
        return left.merge(left, right, mergeType);
    }

    @Override
    public AreaHarvestJson initializeData(AreaHarvestJson data, ModuleInstance moduleInstance) {
        return data.initialize(moduleInstance);
    }

    @Override
    protected MapCodec<AreaHarvestJson> getMapCodec() {
        return CODEC;
    }

    public static class AreaHarvestJson
    implements MergeAble<AreaHarvestJson> {
        @CodecBehavior.Optional
        public DoubleOperationResolvable range = new DoubleOperationResolvable(0.0);

        public AreaHarvestJson initialize(ModuleInstance moduleInstance) {
            AreaHarvestJson init = new AreaHarvestJson();
            init.range = this.range.initialize(moduleInstance);
            return init;
        }

        @Override
        public AreaHarvestJson merge(AreaHarvestJson left, AreaHarvestJson right, MergeType mergeType) {
            AreaHarvestJson init = new AreaHarvestJson();
            init.range = DoubleOperationResolvable.merge(left.range, right.range, mergeType);
            return init;
        }
    }
}

