/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities;

import com.mojang.serialization.Codec;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import smartin.miapi.Miapi;
import smartin.miapi.MixinContextFlags;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.abilities.util.ItemUseAbility;

public class CopyItemAbility
implements ItemUseAbility<ItemContext> {
    public static CopyItemAbility ability;
    public static String KEY;

    public CopyItemAbility() {
        ability = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T withFlag(ItemStack stack, ItemContext item, Supplier<T> action) {
        if (item == null) {
            return null;
        }
        try {
            if (item.fakeItemIdentity) {
                MixinContextFlags.IGNORE_NEXT_GET_ITEM_CALL.get().put(stack, item.item);
            }
            T t = action.get();
            return t;
        }
        finally {
            if (item.fakeItemIdentity) {
                MixinContextFlags.IGNORE_NEXT_GET_ITEM_CALL.get().remove(stack);
            }
        }
    }

    public static void withFlag(ItemStack stack, ItemContext item, Runnable action) {
        if (item == null) {
            return;
        }
        try {
            if (item.fakeItemIdentity) {
                MixinContextFlags.IGNORE_NEXT_GET_ITEM_CALL.get().put(stack, item.item);
            }
            action.run();
        }
        finally {
            if (item.fakeItemIdentity) {
                MixinContextFlags.IGNORE_NEXT_GET_ITEM_CALL.get().remove(stack);
            }
        }
    }

    @Override
    public boolean allowedOnItem(ItemStack stack, Level world, Player player, InteractionHand hand, ItemAbilityManager.AbilityHitContext abilityHitContext, ItemContext context) {
        context.initialize();
        return context.item != null;
    }

    @Override
    public UseAnim getUseAction(ItemStack stack, ItemContext context) {
        return CopyItemAbility.withFlag(stack, (ItemContext)this.getSpecialContext(stack), () -> ((ItemContext)this.getSpecialContext((ItemStack)stack)).item.getUseAnimation(stack));
    }

    @Override
    public int getMaxUseTime(ItemStack stack, LivingEntity entity, ItemContext context) {
        return CopyItemAbility.withFlag(stack, (ItemContext)this.getSpecialContext(stack), () -> ((ItemContext)this.getSpecialContext((ItemStack)stack)).item.getUseDuration(stack, entity));
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand, ItemContext context) {
        ItemStack stack = user.getItemInHand(hand);
        return CopyItemAbility.withFlag(stack, (ItemContext)this.getSpecialContext(stack), () -> ((ItemContext)this.getSpecialContext((ItemStack)stack)).item.use(world, user, hand));
    }

    @Override
    public ItemStack finishUsing(ItemStack stack, Level world, LivingEntity user, ItemContext context) {
        return CopyItemAbility.withFlag(stack, (ItemContext)this.getSpecialContext(stack), () -> ((ItemContext)this.getSpecialContext((ItemStack)stack)).item.finishUsingItem(stack, world, user));
    }

    @Override
    public boolean useOnRelease(ItemStack stack, ItemContext context) {
        Boolean result = CopyItemAbility.withFlag(stack, (ItemContext)this.getSpecialContext(stack), () -> ((ItemContext)this.getSpecialContext((ItemStack)stack)).item.useOnRelease(stack));
        return result != null ? result.booleanValue() : ItemUseAbility.super.useOnRelease(stack, context);
    }

    @Override
    public void onStoppedUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks, ItemContext context) {
        CopyItemAbility.withFlag(stack, (ItemContext)this.getSpecialContext(stack), () -> ((ItemContext)this.getSpecialContext((ItemStack)stack)).item.releaseUsing(stack, world, user, remainingUseTicks));
    }

    @Override
    public void onStoppedHolding(ItemStack stack, Level world, LivingEntity user, ItemContext context) {
        CopyItemAbility.withFlag(stack, (ItemContext)this.getSpecialContext(stack), () -> ItemUseAbility.super.onStoppedHolding(stack, world, user, context));
    }

    @Override
    public InteractionResult useOnBlock(UseOnContext context, ItemContext abilityContext) {
        return CopyItemAbility.withFlag(context.getItemInHand(), (ItemContext)this.getSpecialContext(context.getItemInHand()), () -> ((ItemContext)this.getSpecialContext((ItemStack)context.getItemInHand())).item.useOn(context));
    }

    @Override
    public void usageTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks, ItemContext context) {
        if (((ItemContext)this.getSpecialContext((ItemStack)stack)).item != null) {
            CopyItemAbility.withFlag(stack, (ItemContext)this.getSpecialContext(stack), () -> ((ItemContext)this.getSpecialContext((ItemStack)stack)).item.onUseTick(world, user, stack, remainingUseTicks));
        } else {
            ItemUseAbility.super.usageTick(world, user, stack, remainingUseTicks, context);
        }
    }

    @Override
    public Codec<ItemContext> getCodec() {
        return AutoCodec.of(ItemContext.class).codec();
    }

    @Override
    public ItemContext initialize(ItemContext data, ModuleInstance moduleInstance) {
        ItemContext itemContext = new ItemContext();
        itemContext.id = data.id;
        itemContext.item = (Item)BuiltInRegistries.ITEM.get(data.id);
        itemContext.fakeItemIdentity = data.fakeItemIdentity;
        return itemContext;
    }

    @Override
    public ItemContext getDefaultContext() {
        return new ItemContext();
    }

    static {
        KEY = "copy_item";
    }

    public static class ItemContext {
        public ResourceLocation id = Miapi.id("empty");
        @AutoCodec.Ignored
        public Item item;
        @CodecBehavior.Optional
        @AutoCodec.Name(value="fake_item_identity")
        public boolean fakeItemIdentity = false;

        public void initialize() {
            this.item = (Item)BuiltInRegistries.ITEM.get(this.id);
        }

        public ItemContext() {
        }

        public ItemContext(Item item) {
            this.item = item;
            this.id = item.arch$registryName();
        }
    }
}

