/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import smartin.miapi.MixinContextFlags;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.events.MiapiProjectileEvents;
import smartin.miapi.item.modular.items.bows.ModularCrossbow;
import smartin.miapi.modules.abilities.CopyItemAbility;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.abilities.util.ItemUseAbility;
import smartin.miapi.modules.properties.attributes.AttributeUtil;
import smartin.miapi.modules.properties.projectile.DrawTimeProperty;

public class CrossbowAbility
implements ItemUseAbility<Context> {
    public static final Codec<Context> CODEC = Codec.BOOL.optionalFieldOf("dummy", (Object)false).xmap(Context::new, Context::dummy).codec();

    @Override
    public Codec<Context> getCodec() {
        return CODEC;
    }

    @Override
    public boolean allowedOnItem(ItemStack stack, Level world, Player player, InteractionHand hand, ItemAbilityManager.AbilityHitContext abilityHitContext, Context context) {
        return true;
    }

    @Override
    public UseAnim getUseAction(ItemStack stack, Context context) {
        return UseAnim.CROSSBOW;
    }

    @Override
    public int getMaxUseTime(ItemStack stack, LivingEntity entity, Context context) {
        return CrossbowAbility.getChargeDuration(stack, entity);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand, Context context) {
        ItemStack crossbow = player.getItemInHand(hand);
        ChargedProjectiles charged = (ChargedProjectiles)crossbow.get(DataComponents.CHARGED_PROJECTILES);
        if (charged != null && !charged.isEmpty()) {
            float divergence = (float)Math.pow(12.0, -AttributeUtil.getActualValue(crossbow, EquipmentSlot.MAINHAND, (Attribute)AttributeRegistry.PROJECTILE_ACCURACY.value()));
            float speed = (float)Math.max(0.1, AttributeUtil.getActualValue(crossbow, EquipmentSlot.MAINHAND, (Attribute)AttributeRegistry.PROJECTILE_SPEED.value()) + (double)CrossbowAbility.getShootingPower(charged));
            if (((MiapiProjectileEvents.CrossbowContext)MiapiProjectileEvents.MODULAR_CROSSBOW_PRE_SHOT.invoker()).shoot((LivingEntity)player, crossbow).interruptsFurtherEvaluation()) {
                return InteractionResultHolder.consume((Object)crossbow);
            }
            player.releaseUsingItem();
            if (((MiapiProjectileEvents.CrossbowContext)MiapiProjectileEvents.MODULAR_CROSSBOW_POST_SHOT.invoker()).shoot((LivingEntity)player, crossbow).interruptsFurtherEvaluation()) {
                return InteractionResultHolder.consume((Object)crossbow);
            }
            return InteractionResultHolder.consume((Object)crossbow);
        }
        if (!player.getProjectile(crossbow).isEmpty()) {
            player.startUsingItem(hand);
            return InteractionResultHolder.consume((Object)crossbow);
        }
        return InteractionResultHolder.fail((Object)crossbow);
    }

    @Override
    public void onStoppedUsing(ItemStack stack, Level level, LivingEntity user, int remainingUseTicks, Context context) {
        int ticks = this.getMaxUseTime(stack, user, context) - remainingUseTicks;
        float charge = CrossbowAbility.getPowerForTime(ticks, stack, user);
        MiapiProjectileEvents.CrossbowLoadingContext ctx = new MiapiProjectileEvents.CrossbowLoadingContext(user, stack, user.getProjectile(stack), EquipmentSlot.MAINHAND);
        if (charge >= 1.0f && !CrossbowItem.isCharged((ItemStack)stack) && !((MiapiProjectileEvents.CrossbowContextEvent)MiapiProjectileEvents.MODULAR_CROSSBOW_PRE_LOAD.invoker()).load(ctx).interruptsFurtherEvaluation() && CrossbowAbility.tryLoadProjectiles(user, stack) && ((MiapiProjectileEvents.CrossbowContextEvent)MiapiProjectileEvents.MODULAR_CROSSBOW_POST_LOAD.invoker()).load(ctx).interruptsFurtherEvaluation()) {
            return;
        }
    }

    private static boolean tryLoadProjectiles(LivingEntity shooter, ItemStack crossbowStack) {
        List<ItemStack> list = ModularCrossbow.drawPublic(crossbowStack, shooter.getProjectile(crossbowStack), shooter);
        if (!list.isEmpty()) {
            crossbowStack.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.of(list));
            return true;
        }
        return false;
    }

    private static float getPowerForTime(int timeLeft, ItemStack stack, LivingEntity shooter) {
        float f = (float)timeLeft / (float)CrossbowAbility.getChargeDuration(stack, shooter);
        return Math.min(f, 1.0f);
    }

    private static int getChargeDuration(ItemStack stack, LivingEntity shooter) {
        double drawTime = DrawTimeProperty.property.getValue(stack).orElse(0.25);
        float f = EnchantmentHelper.modifyCrossbowChargingTime((ItemStack)stack, (LivingEntity)shooter, (float)((float)drawTime));
        return (int)(f * 20.0f);
    }

    private static float getShootingPower(ChargedProjectiles projectile) {
        return projectile.contains(Items.FIREWORK_ROCKET) ? 1.6f : 3.15f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T withFlag(ItemStack stack, CopyItemAbility.ItemContext item, Supplier<T> action) {
        if (item == null) {
            return null;
        }
        try {
            if (item.fakeItemIdentity) {
                MixinContextFlags.IGNORE_NEXT_GET_ITEM_CALL.get().put(stack, item.item);
            }
            T t = action.get();
            return t;
        }
        finally {
            if (item.fakeItemIdentity) {
                MixinContextFlags.IGNORE_NEXT_GET_ITEM_CALL.get().remove(stack);
            }
        }
    }

    public record Context(boolean dummy) {
    }
}

