/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities;

import com.mojang.serialization.Codec;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.abilities.util.ItemUseDefaultCooldownAbility;
import smartin.miapi.modules.abilities.util.ItemUseMinHoldAbility;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;
import smartin.miapi.modules.properties.util.MergeType;

public class RiptideAbility
implements ItemUseDefaultCooldownAbility<RiptideContextJson>,
ItemUseMinHoldAbility<RiptideContextJson> {
    public static Codec<RiptideContextJson> CODEC = AutoCodec.of(RiptideContextJson.class).codec();
    public static String KEY = "riptide";

    @Override
    public boolean allowedOnItem(ItemStack itemStack, Level world, Player player, InteractionHand hand, ItemAbilityManager.AbilityHitContext abilityHitContext, RiptideContextJson context) {
        return EnchantmentHelper.getTridentSpinAttackStrength((ItemStack)itemStack, (LivingEntity)player) != 0.0f;
    }

    @Override
    public UseAnim getUseAction(ItemStack itemStack, RiptideContextJson context) {
        return UseAnim.SPEAR;
    }

    @Override
    public int getMaxUseTime(ItemStack itemStack, LivingEntity entity, RiptideContextJson context) {
        return 7200;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand, RiptideContextJson context) {
        ServerLevel serverLevel;
        ItemStack itemStack = user.getItemInHand(hand);
        if (itemStack.getDamageValue() >= itemStack.getMaxDamage() - 1) {
            return InteractionResultHolder.fail((Object)itemStack);
        }
        if (world instanceof ServerLevel && EnchantmentHelper.getTridentReturnToOwnerAcceleration((ServerLevel)(serverLevel = (ServerLevel)world), (ItemStack)itemStack, (Entity)user) > 0 && !user.isInWaterOrRain()) {
            return InteractionResultHolder.fail((Object)itemStack);
        }
        user.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)itemStack);
    }

    @Override
    public Codec<RiptideContextJson> getCodec() {
        return CODEC;
    }

    @Override
    public void onStoppedUsingAfter(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged, RiptideContextJson context) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            int var6 = this.getMaxUseTime(stack, livingEntity, context) - timeCharged;
            if (var6 >= 10) {
                float f = EnchantmentHelper.getTridentSpinAttackStrength((ItemStack)stack, (LivingEntity)player);
                if (player.isInWaterOrRain() && !RiptideAbility.isTooDamagedToUse(stack)) {
                    Holder holder = EnchantmentHelper.pickHighestLevel((ItemStack)stack, (DataComponentType)EnchantmentEffectComponents.TRIDENT_SOUND).orElse(SoundEvents.TRIDENT_THROW);
                    player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                    if (f > 0.0f) {
                        float g = player.getYRot();
                        float h = player.getXRot();
                        float j = -Mth.sin((float)(g * ((float)Math.PI / 180))) * Mth.cos((float)(h * ((float)Math.PI / 180)));
                        float k = -Mth.sin((float)(h * ((float)Math.PI / 180)));
                        float l = Mth.cos((float)(g * ((float)Math.PI / 180))) * Mth.cos((float)(h * ((float)Math.PI / 180)));
                        float m = Mth.sqrt((float)(j * j + k * k + l * l));
                        player.push((double)(j *= f / m), (double)(k *= f / m), (double)(l *= f / m));
                        player.startAutoSpinAttack(20, 8.0f, stack);
                        if (player.onGround()) {
                            float n = 1.1999999f;
                            player.move(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
                        }
                        level.playSound((Player)null, (Entity)player, (SoundEvent)holder.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                }
            }
        }
    }

    private static boolean isTooDamagedToUse(ItemStack stack) {
        return stack.getDamageValue() >= stack.getMaxDamage() - 1;
    }

    @Override
    public RiptideContextJson getDefaultContext() {
        return null;
    }

    @Override
    public int getMinHoldTime(ItemStack itemStack) {
        return (int)((RiptideContextJson)this.getSpecialContext((ItemStack)itemStack)).minUse.getValue();
    }

    @Override
    public int getCooldown(ItemStack itemStack) {
        return (int)((RiptideContextJson)this.getSpecialContext((ItemStack)itemStack)).cooldown.getValue();
    }

    @Override
    public RiptideContextJson initialize(RiptideContextJson json, ModuleInstance moduleInstance) {
        return json.initialize(moduleInstance);
    }

    @Override
    public RiptideContextJson merge(RiptideContextJson left, RiptideContextJson right, MergeType mergeType) {
        RiptideContextJson merged = new RiptideContextJson();
        merged.cooldown = left.cooldown.merge(right.cooldown, mergeType);
        merged.minUse = left.minUse.merge(right.minUse, mergeType);
        merged.spinDuration = left.spinDuration.merge(right.spinDuration, mergeType);
        merged.riptideStrength = left.riptideStrength.merge(right.riptideStrength, mergeType);
        merged.customSound = MergeType.EXTEND.equals((Object)mergeType) && left.customSound != null ? left.customSound : right.customSound;
        return merged;
    }

    public static class RiptideContextJson {
        @CodecBehavior.Optional
        public DoubleOperationResolvable cooldown = new DoubleOperationResolvable(20.0);
        @AutoCodec.Name(value="min_use")
        @CodecBehavior.Optional
        public DoubleOperationResolvable minUse = new DoubleOperationResolvable(10.0);
        @AutoCodec.Name(value="spin_duration_base")
        @CodecBehavior.Optional
        public DoubleOperationResolvable spinDuration = new DoubleOperationResolvable(20.0);
        @AutoCodec.Name(value="riptide_strength")
        @CodecBehavior.Optional
        public DoubleOperationResolvable riptideStrength = new DoubleOperationResolvable(20.0);
        @CodecBehavior.Optional
        @AutoCodec.Name(value="custom_sound")
        public ResourceLocation customSound = null;

        public RiptideContextJson initialize(ModuleInstance moduleInstance) {
            RiptideContextJson init = new RiptideContextJson();
            init.cooldown = this.cooldown.initialize(moduleInstance);
            init.minUse = this.minUse.initialize(moduleInstance);
            init.spinDuration = this.spinDuration.initialize(moduleInstance);
            init.riptideStrength = this.riptideStrength.initialize(moduleInstance);
            init.customSound = this.customSound;
            return init;
        }

        public SoundEvent resolveSoundEvent(int riptideLevel) {
            if (this.customSound != null && BuiltInRegistries.SOUND_EVENT.containsKey(this.customSound)) {
                return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(this.customSound);
            }
            if (riptideLevel >= 3) {
                return (SoundEvent)SoundEvents.TRIDENT_RIPTIDE_3.value();
            }
            if (riptideLevel == 2) {
                return (SoundEvent)SoundEvents.TRIDENT_RIPTIDE_2.value();
            }
            return (SoundEvent)SoundEvents.TRIDENT_RIPTIDE_1.value();
        }
    }
}

