/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities;

import com.mojang.serialization.Codec;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import com.redpxnda.nucleus.network.clientbound.ParticleCreationPacket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import smartin.miapi.mixin.LivingEntityAccessor;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.abilities.util.AbilityProperty;
import smartin.miapi.modules.abilities.util.AttackUtil;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.abilities.util.ItemUseDefaultCooldownAbility;
import smartin.miapi.modules.abilities.util.ItemUseMinHoldAbility;
import smartin.miapi.modules.properties.LoreProperty;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;
import smartin.miapi.modules.properties.util.MergeType;

public class SpecialAttackAbility
implements ItemUseDefaultCooldownAbility<SpecialAttackJson>,
ItemUseMinHoldAbility<SpecialAttackJson> {
    public static Codec<SpecialAttackJson> CODEC = AutoCodec.of(SpecialAttackJson.class).codec();

    public SpecialAttackAbility() {
        LoreProperty.bottomLoreSuppliers.add(itemStack -> {
            ArrayList<MutableComponent> texts = new ArrayList<MutableComponent>();
            if (AbilityProperty.isPrimaryAbility(this, itemStack)) {
                texts.add(Component.translatable((String)"miapi.ability.heavy_attack.lore"));
            }
            return texts;
        });
    }

    @Override
    public boolean allowedOnItem(ItemStack itemStack, Level world, Player player, InteractionHand hand, ItemAbilityManager.AbilityHitContext abilityHitContext, SpecialAttackJson context) {
        return true;
    }

    @Override
    public UseAnim getUseAction(ItemStack itemStack, SpecialAttackJson context) {
        return UseAnim.SPEAR;
    }

    @Override
    public int getMaxUseTime(ItemStack itemStack, LivingEntity entity, SpecialAttackJson context) {
        return 72000;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand, SpecialAttackJson context) {
        if (user.getCooldowns().isOnCooldown(user.getItemInHand(hand).getItem())) {
            return InteractionResultHolder.pass((Object)user.getItemInHand(hand));
        }
        user.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)user.getItemInHand(hand));
    }

    @Override
    public Codec<SpecialAttackJson> getCodec() {
        return CODEC;
    }

    @Override
    public void onStoppedUsingAfter(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks, SpecialAttackJson context) {
        SpecialAttackJson specialAttackJson = (SpecialAttackJson)this.getSpecialContext(stack);
        if (user instanceof Player) {
            Entity target2;
            EntityHitResult entityHitResult;
            Player player = (Player)user;
            if ((double)(this.getMaxUseTime(stack, user, context) - remainingUseTicks) > specialAttackJson.minHold.getValue() && (entityHitResult = AttackUtil.raycastFromPlayer(specialAttackJson.range.evaluate(3.5, 3.5), player)) != null && (target2 = entityHitResult.getEntity()) instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)target2;
                ((LivingEntityAccessor)player).attacking(target);
                float damage = (float)((double)((float)player.getAttributeValue(Attributes.ATTACK_DAMAGE)) * specialAttackJson.damage.getValue());
                float sweeping = (float)specialAttackJson.sweeping.getValue();
                AttackUtil.performAttack(player, target, damage, true, stack);
                if (sweeping > 0.0f) {
                    AttackUtil.performSweeping(player, target, sweeping, damage);
                }
                player.swing(player.getUsedItemHand());
                player.getCooldowns().addCooldown(stack.getItem(), (int)specialAttackJson.cooldown.getValue());
                Level level = player.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)level;
                    specialAttackJson.particleEffect.forEach(particleOptions -> {
                        ParticleCreationPacket particleCreationPacket = new ParticleCreationPacket(particleOptions, player.getX(), player.getY(), player.getZ(), 0.0, 0.0, 0.0);
                        particleCreationPacket.send(serverWorld);
                    });
                }
            }
        }
    }

    @Override
    public int getCooldown(ItemStack itemStack) {
        return (int)((SpecialAttackJson)this.getSpecialContext((ItemStack)itemStack)).cooldown.getValue();
    }

    @Override
    public SpecialAttackJson getDefaultContext() {
        return null;
    }

    @Override
    public SpecialAttackJson initialize(SpecialAttackJson json, ModuleInstance moduleInstance) {
        return json.initialize(moduleInstance);
    }

    @Override
    public int getMinHoldTime(ItemStack itemStack) {
        return (int)((SpecialAttackJson)this.getSpecialContext((ItemStack)itemStack)).minHold.getValue();
    }

    @Override
    public SpecialAttackJson merge(SpecialAttackJson left, SpecialAttackJson right, MergeType mergeType) {
        SpecialAttackJson merged = new SpecialAttackJson();
        merged.damage = left.damage.merge(right.damage, mergeType);
        merged.sweeping = left.sweeping.merge(right.sweeping, mergeType);
        merged.range = left.range.merge(right.range, mergeType);
        merged.minHold = left.minHold.merge(right.minHold, mergeType);
        merged.cooldown = left.cooldown.merge(right.cooldown, mergeType);
        if (MergeType.EXTEND.equals((Object)mergeType)) {
            merged.description = left.description;
            merged.title = left.description;
        } else {
            merged.description = right.description;
            merged.title = right.description;
        }
        if (MergeType.OVERWRITE.equals((Object)mergeType)) {
            merged.particleEffect = right.particleEffect;
        } else {
            ArrayList<ParticleOptions> list = new ArrayList<ParticleOptions>(right.particleEffect);
            list.addAll(left.particleEffect);
            merged.particleEffect = list;
        }
        return merged;
    }

    public static class SpecialAttackJson {
        public DoubleOperationResolvable damage = new DoubleOperationResolvable(1.0);
        public DoubleOperationResolvable sweeping = new DoubleOperationResolvable(0.0);
        public DoubleOperationResolvable range = new DoubleOperationResolvable(3.5);
        @AutoCodec.Name(value="min_hold")
        @CodecBehavior.Optional
        public DoubleOperationResolvable minHold = new DoubleOperationResolvable(15.0);
        @CodecBehavior.Optional
        public DoubleOperationResolvable cooldown = new DoubleOperationResolvable(10.0);
        @CodecBehavior.Optional
        public Component title = Component.translatable((String)"miapi.ability.heavy_attack.title");
        @CodecBehavior.Optional
        public Component description = Component.translatable((String)"miapi.ability.heavy_attack.description");
        @CodecBehavior.Optional
        public List<ParticleOptions> particleEffect = new ArrayList<ParticleOptions>();

        public SpecialAttackJson initialize(ModuleInstance moduleInstance) {
            SpecialAttackJson specialAttackJson = new SpecialAttackJson();
            specialAttackJson.damage = this.damage.initialize(moduleInstance);
            specialAttackJson.sweeping = this.sweeping.initialize(moduleInstance);
            specialAttackJson.range = this.range.initialize(moduleInstance);
            specialAttackJson.minHold = this.minHold.initialize(moduleInstance);
            specialAttackJson.cooldown = this.cooldown.initialize(moduleInstance);
            specialAttackJson.title = this.title;
            specialAttackJson.description = this.description;
            specialAttackJson.particleEffect = this.particleEffect;
            return specialAttackJson;
        }
    }
}

