/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities.shield;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.mojang.serialization.MapCodec;
import com.redpxnda.nucleus.pose.server.ServerPoseFacet;
import dev.architectury.event.EventResult;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import smartin.miapi.Miapi;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.abilities.shield.BlockDataOld;
import smartin.miapi.modules.abilities.util.AbilityProperty;
import smartin.miapi.modules.abilities.util.EntityAttributeAbility;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.abilities.util.MinMaxCDAbility;
import smartin.miapi.modules.properties.LoreProperty;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.registries.RegistryInventory;

public class BlockAbility
extends EntityAttributeAbility<BlockDataOld> {
    ResourceLocation id = Miapi.id("block_ability_temporary_attribute");

    public BlockAbility() {
        LoreProperty.bottomLoreSuppliers.add(itemStack -> {
            ArrayList<MutableComponent> texts = new ArrayList<MutableComponent>();
            if (AbilityProperty.isPrimaryAbility(this, itemStack)) {
                MutableComponent raw = Component.translatable((String)"miapi.ability.block.lore");
                texts.add(raw);
            }
            return texts;
        });
        MiapiEvents.LIVING_HURT.register(event -> {
            LivingEntity patt0$temp = event.defender;
            if (!(patt0$temp instanceof Player)) {
                return EventResult.pass();
            }
            Player player = (Player)patt0$temp;
            ItemStack stack = player.getUseItem();
            if (stack == null || stack.isEmpty()) {
                return EventResult.pass();
            }
            ModuleInstance moduleInstance = ItemModule.getModules(stack);
            BlockDataOld data = this.getData(stack).orElse(null);
            if (data == null || moduleInstance == null) {
                return EventResult.pass();
            }
            player.getCooldowns().addCooldown(stack.getItem(), this.getCooldown(stack));
            Entity patt1$temp = event.damageSource.getEntity();
            if (patt1$temp instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)patt1$temp;
                int attackerCD = (int)data.cooldownAttackerWeapon.getValue();
                if (attacker instanceof Player) {
                    Player p = (Player)attacker;
                    ItemStack attackStack = p.getMainHandItem();
                    if (!attackStack.isEmpty()) {
                        p.getCooldowns().addCooldown(attackStack.getItem(), attackerCD);
                    }
                } else {
                    attacker.addEffect(new MobEffectInstance(RegistryInventory.stunEffect, attackerCD));
                }
                float returnPercent = (float)data.damageReturnPercent.getValue() / 100.0f;
                float reflected = event.amount * returnPercent;
                attacker.hurt(player.damageSources().playerAttack(player), reflected);
            }
            if (data.sound != null) {
                Holder holder = Holder.direct((Object)SoundEvent.createVariableRangeEvent((ResourceLocation)data.sound));
                player.playSound((SoundEvent)holder.value(), (float)data.volume.getValue(), (float)data.pitch.getValue());
            }
            return EventResult.pass();
        });
    }

    @Override
    protected Multimap<Holder<Attribute>, AttributeModifier> getAttributes(ItemStack itemStack) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        double value = this.getData(itemStack).map(c -> c.blocking.getValue()).orElse(1.0);
        value = BlockAbility.calculate(value);
        multimap.put((Object)Attributes.MOVEMENT_SPEED, (Object)new AttributeModifier(this.id, -(value / 2.0) / 100.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        multimap.put(AttributeRegistry.DAMAGE_RESISTANCE, (Object)new AttributeModifier(this.id, value, AttributeModifier.Operation.ADD_VALUE));
        return multimap;
    }

    public static double calculate(double value) {
        return 160.0 / (1.0 + Math.exp(-value / 50.0)) - 80.0;
    }

    @Override
    public boolean allowedOnItem(ItemStack itemStack, Level world, Player player, InteractionHand hand, ItemAbilityManager.AbilityHitContext abilityHitContext, MinMaxCDAbility.MinMaxCDData<BlockDataOld> context) {
        return true;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand, MinMaxCDAbility.MinMaxCDData<BlockDataOld> context) {
        this.setAnimation(user, hand);
        return super.use(world, user, hand, context);
    }

    @Override
    public ItemStack finishUsing(ItemStack stack, Level world, LivingEntity user, MinMaxCDAbility.MinMaxCDData<BlockDataOld> context) {
        this.resetAnimation(user);
        return super.finishUsing(stack, world, user, context);
    }

    @Override
    public void onStoppedUsingAfter(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks, MinMaxCDAbility.MinMaxCDData<BlockDataOld> context) {
        this.resetAnimation(user);
        super.onStoppedUsingAfter(stack, world, user, remainingUseTicks, context);
    }

    @Override
    public void onStoppedHolding(ItemStack stack, Level world, LivingEntity user, MinMaxCDAbility.MinMaxCDData<BlockDataOld> context) {
        this.resetAnimation(user);
        super.onStoppedHolding(stack, world, user, context);
    }

    public void setAnimation(Player p, InteractionHand hand) {
        ServerPlayer player;
        ServerPoseFacet facet;
        if (p instanceof ServerPlayer && (facet = (ServerPoseFacet)ServerPoseFacet.KEY.get((Entity)(player = (ServerPlayer)p))) != null) {
            facet.set("miapi:block", player, hand);
        }
    }

    public void resetAnimation(LivingEntity entity) {
        ServerPlayer player;
        ServerPoseFacet facet;
        if (entity instanceof ServerPlayer && (facet = (ServerPoseFacet)ServerPoseFacet.KEY.get((Entity)(player = (ServerPlayer)entity))) != null) {
            facet.reset(player);
        }
    }

    @Override
    protected MapCodec<BlockDataOld> getMapCodec() {
        return BlockDataOld.CODEC;
    }

    @Override
    protected BlockDataOld mergeData(BlockDataOld left, BlockDataOld right, MergeType mergeType) {
        return left.merge(left, right, mergeType);
    }

    @Override
    public BlockDataOld initializeData(BlockDataOld data, ModuleInstance moduleInstance) {
        return data.initialize(data, moduleInstance);
    }
}

