/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities.shield;

import com.mojang.serialization.MapCodec;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.pose.server.ServerPoseFacet;
import dev.architectury.event.EventResult;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableInt;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.client.gui.crafting.statdisplay.DoubleResolvableStatDisplay;
import smartin.miapi.client.gui.crafting.statdisplay.StatListWidget;
import smartin.miapi.events.ClientEvents;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.mixin.CooldownInstanceAccessor;
import smartin.miapi.mixin.ItemCooldownsAccessor;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.abilities.shield.BlockData;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.abilities.util.MinMaxCDAbility;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.registries.RegistryInventory;

public class ParryBlock
extends MinMaxCDAbility<BlockData> {
    public static final String KEY = "parry_block";
    public static final MapCodec<BlockData> CODEC = AutoCodec.of(BlockData.class);

    public ParryBlock() {
        super(0, 7200, 30);
        MiapiEvents.GET_ITEM_SHIELD_COOLDOWN.register((Object)new MiapiEvents.CooldownAttackingWeaponGatherEvent(this){

            @Override
            public void durability(MutableInt cooldown, ItemStack attacking, ItemStack shield, LivingEntity defender, Entity attacker) {
                if (ModularItem.isModularItem(attacking) && attacker instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)attacker;
                    double value = livingEntity.getAttributeValue(AttributeRegistry.SHIELD_BREAK);
                    cooldown.setValue((Number)(value * 20.0));
                }
                if (cooldown.getValue() == 0 && attacking.getItem() instanceof AxeItem) {
                    cooldown.setValue(100);
                }
            }
        }, -1.0f);
        MiapiEvents.LIVING_HURT.register(event -> {
            SoundEvent soundEvent;
            Vec3 toAttacker;
            LivingEntity patt0$temp = event.defender;
            if (!(patt0$temp instanceof Player)) {
                return EventResult.pass();
            }
            Player player = (Player)patt0$temp;
            ItemStack stack = player.getUseItem();
            if (stack == null || stack.isEmpty()) {
                return EventResult.pass();
            }
            ModuleInstance moduleInstance = ItemModule.getModules(stack);
            BlockData data = this.getData(stack).orElse(null);
            if (data == null || moduleInstance == null || event.attacker == null) {
                return EventResult.pass();
            }
            double allowedAngle = data.angle().getValue();
            Vec3 playerLook = player.getLookAngle().normalize();
            double angle = Math.toDegrees(Math.acos(playerLook.dot(toAttacker = event.attacker.position().subtract(player.position()).normalize())));
            if (angle <= allowedAngle && (angle = Math.toDegrees(Math.acos(playerLook.dot(toAttacker = event.attacker.getEyePosition().subtract(player.position()).normalize())))) <= allowedAngle) {
                return EventResult.interruptTrue();
            }
            Entity patt1$temp = event.damageSource.getEntity();
            if (patt1$temp instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)patt1$temp;
                int attackerCD = (int)data.cooldownAttackerWeapon().getValue();
                if (attacker instanceof Player) {
                    Player p = (Player)attacker;
                    ItemStack attackStack = p.getMainHandItem();
                    if (!attackStack.isEmpty()) {
                        this.addCooldown(p, attackStack, attackerCD);
                    }
                } else if (attackerCD > 10) {
                    attacker.addEffect(new MobEffectInstance(RegistryInventory.stunEffect, attackerCD));
                }
                float returnPercent = (float)data.damageReturnPercent().getValue() / 100.0f;
                if (returnPercent > 1.0f) {
                    float reflected = event.amount * returnPercent;
                    attacker.hurt(player.damageSources().playerAttack(player), reflected);
                }
            }
            if (data.sound() != null && (soundEvent = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(data.sound())) != null && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.level().playSound(player, player.getOnPos(), soundEvent, SoundSource.PLAYERS, (float)data.volume().getValue(), (float)data.pitch().getValue());
            }
            double blocking = data.blocking().getValue();
            int cooldown = this.getCooldown(stack);
            if (data.respectAttackingWeaponCooldown().getValue() > 0.0) {
                MutableInt base = new MutableInt(0);
                ((MiapiEvents.CooldownAttackingWeaponGatherEvent)MiapiEvents.GET_ITEM_SHIELD_COOLDOWN.invoker()).durability(base, event.getMainCausingStack(), stack, event.defender, event.attacker);
                cooldown += base.getValue().intValue();
            }
            if (blocking >= 100.0) {
                this.addCooldown(player, stack, cooldown);
                return EventResult.interruptDefault();
            }
            if (blocking > 0.0) {
                float blockPercent = (float)blocking / 100.0f;
                event.amount = Math.max(0.0f, event.amount - blockPercent * event.amount);
                this.addCooldown(player, stack, cooldown);
                return EventResult.pass();
            }
            return EventResult.pass();
        });
        if (Platform.getEnvironment() == Env.CLIENT) {
            ClientEvents.STAT_WIDGET_REGISTRATION.register(this::registerStatDisplays);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerStatDisplays() {
        StatListWidget.addStatDisplay(DoubleResolvableStatDisplay.builder(s -> ItemAbilityManager.getAbilities(s).stream().filter(a -> a.ability() instanceof ParryBlock).findAny().map(a -> ((BlockData)((MinMaxCDAbility.MinMaxCDData)a.context()).data()).blocking())).setName((Component)Component.translatable((String)"miapi.stat.miapi.ability.blocking.block")).setHoverDescription((Component)Component.translatable((String)"miapi.stat.miapi.ability.blocking.block.description")).build());
        StatListWidget.addStatDisplay(DoubleResolvableStatDisplay.builder(s -> ItemAbilityManager.getAbilities(s).stream().filter(a -> a.ability() instanceof ParryBlock).findAny().map(a -> ((MinMaxCDAbility.MinMaxCDData)a.context()).max())).setName((Component)Component.translatable((String)"miapi.stat.miapi.ability.blocking.max_use")).setHoverDescription((Component)Component.translatable((String)"miapi.stat.miapi.ability.blocking.max_use.description")).build());
        StatListWidget.addStatDisplay(DoubleResolvableStatDisplay.builder(s -> ItemAbilityManager.getAbilities(s).stream().filter(a -> a.ability() instanceof ParryBlock).findAny().map(a -> ((MinMaxCDAbility.MinMaxCDData)a.context()).min())).setName((Component)Component.translatable((String)"miapi.stat.miapi.ability.blocking.min_use")).setHoverDescription((Component)Component.translatable((String)"miapi.stat.miapi.ability.blocking.min_use.description")).build());
        StatListWidget.addStatDisplay(DoubleResolvableStatDisplay.builder(s -> ItemAbilityManager.getAbilities(s).stream().filter(a -> a.ability() instanceof ParryBlock).findAny().map(a -> ((BlockData)((MinMaxCDAbility.MinMaxCDData)a.context()).data()).respectAttackingWeaponCooldown())).setName((Component)Component.translatable((String)"miapi.stat.miapi.ability.blocking.respect_attacker_weapon_cd")).setHoverDescription((Component)Component.translatable((String)"miapi.stat.miapi.ability.blocking.respect_attacker_weapon_cd")).build());
        StatListWidget.addStatDisplay(DoubleResolvableStatDisplay.builder(s -> ItemAbilityManager.getAbilities(s).stream().filter(a -> a.ability() instanceof ParryBlock).findAny().map(a -> ((BlockData)((MinMaxCDAbility.MinMaxCDData)a.context()).data()).angle())).setName((Component)Component.translatable((String)"miapi.stat.miapi.ability.blocking.angle")).setHoverDescription((Component)Component.translatable((String)"miapi.stat.miapi.ability.blocking.angle")).build());
        StatListWidget.addStatDisplay(DoubleResolvableStatDisplay.builder(s -> ItemAbilityManager.getAbilities(s).stream().filter(a -> a.ability() instanceof ParryBlock).findAny().map(a -> ((BlockData)((MinMaxCDAbility.MinMaxCDData)a.context()).data()).cooldownAttackerWeapon())).setName((Component)Component.translatable((String)"miapi.stat.miapi.ability.blocking.cooldown_attacker_weapon")).setHoverDescription((Component)Component.translatable((String)"miapi.stat.miapi.ability.blocking.cooldown_attacker_weapon.description")).build());
        StatListWidget.addStatDisplay(DoubleResolvableStatDisplay.builder(s -> ItemAbilityManager.getAbilities(s).stream().filter(a -> a.ability() instanceof ParryBlock).findAny().map(a -> ((BlockData)((MinMaxCDAbility.MinMaxCDData)a.context()).data()).damageReturnPercent())).setName((Component)Component.translatable((String)"miapi.stat.miapi.ability.blocking.damage_return_percent")).setHoverDescription((Component)Component.translatable((String)"miapi.stat.miapi.ability.blocking.damage_return_percent.description")).build());
        StatListWidget.addStatDisplay(DoubleResolvableStatDisplay.builder(s -> ItemAbilityManager.getAbilities(s).stream().filter(a -> a.ability() instanceof ParryBlock).findAny().map(a -> ((BlockData)((MinMaxCDAbility.MinMaxCDData)a.context()).data()).cooldownMissTime())).setName((Component)Component.translatable((String)"miapi.stat.miapi.ability.blocking.cooldown_miss_time")).setHoverDescription((Component)Component.translatable((String)"miapi.stat.miapi.ability.blocking.cooldown_miss_time.description")).build());
    }

    public void addCooldown(Player player, ItemStack stack, int cooldown) {
        if (cooldown > 0) {
            int currentCD;
            Map<Item, ItemCooldowns.CooldownInstance> cd = ((ItemCooldownsAccessor)player.getCooldowns()).getCooldowns();
            if (cd.containsKey(stack.getItem()) && (currentCD = ((CooldownInstanceAccessor)cd.get(stack.getItem())).getEndTime() - ((ItemCooldownsAccessor)player.getCooldowns()).getTickCount()) > cooldown) {
                return;
            }
            player.getCooldowns().addCooldown(stack.getItem(), cooldown);
            player.stopUsingItem();
            player.getCooldowns().addCooldown(stack.getItem(), cooldown);
        }
    }

    @Override
    protected MapCodec<BlockData> getMapCodec() {
        return BlockData.CODEC;
    }

    @Override
    protected BlockData mergeData(BlockData left, BlockData right, MergeType mergeType) {
        return left.merge(left, right, mergeType);
    }

    @Override
    public BlockData initializeData(BlockData data, ModuleInstance moduleInstance) {
        return data.initialize(data, moduleInstance);
    }

    @Override
    public boolean allowedOnItem(ItemStack itemStack, Level world, Player player, InteractionHand hand, ItemAbilityManager.AbilityHitContext abilityHitContext, MinMaxCDAbility.MinMaxCDData<BlockData> context) {
        return true;
    }

    @Override
    public UseAnim getUseAction(ItemStack itemStack, MinMaxCDAbility.MinMaxCDData<BlockData> context) {
        BlockData data;
        if (this.getData(itemStack).isPresent() && (data = (BlockData)this.getData(itemStack).get()).pose().isEmpty()) {
            return UseAnim.BLOCK;
        }
        return UseAnim.NONE;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand, MinMaxCDAbility.MinMaxCDData<BlockData> context) {
        if (!world.isClientSide && user instanceof ServerPlayer) {
            BlockData data;
            ServerPlayer serverPlayer = (ServerPlayer)user;
            ModuleInstance moduleInstance = ItemModule.getModules(user.getItemInHand(hand));
            if (moduleInstance != null && (data = (BlockData)this.getData(user.getItemInHand(hand)).orElse(null)) != null && data.pose() != null && data.pose().isPresent()) {
                this.setAnimation((Player)serverPlayer, data.pose().get(), hand);
            }
        }
        user.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)user.getItemInHand(hand));
    }

    @Override
    public ItemStack finishUsing(ItemStack stack, Level world, LivingEntity user, MinMaxCDAbility.MinMaxCDData<BlockData> context) {
        this.resetAnimation(user);
        this.applyCooldownMissTime(stack, user);
        return super.finishUsing(stack, world, user, context);
    }

    @Override
    public void onStoppedUsingAfter(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks, MinMaxCDAbility.MinMaxCDData<BlockData> context) {
        this.resetAnimation(user);
        super.onStoppedUsingAfter(stack, world, user, remainingUseTicks, context);
        this.applyCooldownMissTime(stack, user);
    }

    @Override
    public void onStoppedHolding(ItemStack stack, Level world, LivingEntity user, MinMaxCDAbility.MinMaxCDData<BlockData> context) {
        this.resetAnimation(user);
        super.onStoppedHolding(stack, world, user, context);
        this.applyCooldownMissTime(stack, user);
    }

    public void applyCooldownMissTime(ItemStack itemStack, LivingEntity livingEntity) {
        BlockData data = this.getData(itemStack).orElse(null);
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            if (data != null) {
                this.addCooldown((Player)serverPlayer, itemStack, (int)data.cooldownMissTime().getValue());
            }
        }
    }

    public void setAnimation(Player p, ResourceLocation id, InteractionHand hand) {
        ServerPlayer player;
        ServerPoseFacet facet;
        if (p instanceof ServerPlayer && (facet = (ServerPoseFacet)ServerPoseFacet.KEY.get((Entity)(player = (ServerPlayer)p))) != null) {
            facet.set(id.toString(), player, hand);
        }
    }

    public void resetAnimation(LivingEntity entity) {
        ServerPlayer player;
        ServerPoseFacet facet;
        if (entity instanceof ServerPlayer && (facet = (ServerPoseFacet)ServerPoseFacet.KEY.get((Entity)(player = (ServerPlayer)entity))) != null) {
            facet.reset(player);
        }
    }
}

