/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities.toolabilities;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import smartin.miapi.mixin.item.ShovelItemAccessor;
import smartin.miapi.modules.abilities.util.MinMaxCDAbility;
import smartin.miapi.modules.abilities.util.ToolAbilities;

public class ShovelAbility
extends ToolAbilities {
    public static final String KEY = "shovel_ability";

    @Override
    public Optional<BlockState> getBlockState(BlockState blockState, UseOnContext context) {
        return Optional.empty();
    }

    @Override
    public InteractionResult useOnBlock(UseOnContext context, MinMaxCDAbility.MinMaxCDData<ToolAbilities.ToolAbilityContext> abilityContext) {
        Level world = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        BlockState blockState = world.getBlockState(blockPos);
        if (context.getClickedFace() == Direction.DOWN) {
            return InteractionResult.PASS;
        }
        Player playerEntity = context.getPlayer();
        BlockState blockState2 = ShovelItemAccessor.getPATH_STATES().get(blockState.getBlock());
        BlockState blockState3 = null;
        if (blockState2 != null && world.getBlockState(blockPos.above()).isAir()) {
            world.playSound(playerEntity, blockPos, SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS, 1.0f, 1.0f);
            blockState3 = blockState2;
        } else if (blockState.getBlock() instanceof CampfireBlock && ((Boolean)blockState.getValue((Property)CampfireBlock.LIT)).booleanValue()) {
            if (!world.isClientSide()) {
                world.levelEvent(null, 1009, blockPos, 0);
            }
            CampfireBlock.dowse((Entity)context.getPlayer(), (LevelAccessor)world, (BlockPos)blockPos, (BlockState)blockState);
            blockState3 = (BlockState)blockState.setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false));
        }
        if (blockState3 != null) {
            if (!world.isClientSide) {
                world.setBlock(blockPos, blockState3, 11);
                world.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockPos, GameEvent.Context.of((Entity)playerEntity, (BlockState)blockState3));
                if (playerEntity != null) {
                    context.getItemInHand().hurtAndBreak(1, (LivingEntity)playerEntity, this.getEquipmentSlot(context.getHand()));
                }
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return InteractionResult.PASS;
    }
}

