/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import smartin.miapi.Miapi;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.item.modular.VisualModularItem;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.abilities.util.ItemUseAbility;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;
import smartin.miapi.modules.properties.util.InitializeAble;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.registries.RegistryInventory;

public class AbilityProperty
extends CodecProperty<List<AbilityContext<?>>> {
    public static final String KEY = "ability_context";
    public static AbilityProperty property;
    public static Codec<Map<ItemUseAbility<?>, Object>> OLD_CODEC_RAW;
    public static Codec<List<AbilityContext<?>>> OLD_CODEC;
    public static Codec<List<AbilityContext<?>>> CODEC;

    public static boolean isPrimaryAbility(ItemUseAbility<?> itemUseAbility, ItemStack itemStack) {
        if (VisualModularItem.isVisualModularItem(itemStack) && !ModularItem.isModularItem(itemStack)) {
            return false;
        }
        List list = property.getData(itemStack).orElse(List.of());
        if (!list.isEmpty()) {
            return ((AbilityContext)list.getFirst()).ability.equals(itemUseAbility);
        }
        return false;
    }

    public AbilityProperty() {
        super(CODEC);
        property = this;
        RegistryInventory.ITEM_USE_ABILITY_MIAPI_REGISTRY.addCallback((id, ability) -> {
            if (id != null && ability != null) {
                if (ability.getCodec() == null) {
                    throw new RuntimeException("Ability has no Codec! " + String.valueOf(id) + " " + ability.toString());
                }
                AbilityContext.registerAbilityCodec(id, ability);
            }
        });
    }

    @Override
    public List<AbilityContext<?>> merge(List<AbilityContext<?>> left, List<AbilityContext<?>> right, MergeType mergeType) {
        HashMap<String, AbilityContext> merged = new HashMap<String, AbilityContext>();
        Function<AbilityContext, String> makeKey = h -> String.valueOf(h.id) + "|" + String.valueOf(h.abilityId());
        for (AbilityContext<?> l2 : left) {
            merged.put(makeKey.apply(l2), l2);
        }
        for (AbilityContext<?> r : right) {
            merged.merge(makeKey.apply(r), r, (? super V l, ? super V rr) -> l.mergeUnchecked((AbilityContext<?>)l, (AbilityContext<?>)rr, mergeType));
        }
        return new ArrayList(merged.values());
    }

    @Override
    public List<AbilityContext<?>> initialize(List<AbilityContext<?>> left, ModuleInstance context) {
        ArrayList list = new ArrayList();
        left.forEach(abilityContext -> list.add(AbilityProperty.init(abilityContext, context)));
        return list;
    }

    static <T> AbilityContext<T> init(AbilityContext<T> context, ModuleInstance moduleInstance) {
        return context.initialize(context, moduleInstance);
    }

    static {
        OLD_CODEC_RAW = new Codec<Map<ItemUseAbility<?>, Object>>(){

            public <T> DataResult<T> encode(Map<ItemUseAbility<?>, Object> input, DynamicOps<T> ops, T prefix) {
                LinkedHashMap encodedMap = new LinkedHashMap();
                RecordBuilder map = ops.mapBuilder();
                for (Map.Entry<ItemUseAbility<?>, Object> entry : input.entrySet()) {
                    ItemUseAbility<?> ability = entry.getKey();
                    Object data = entry.getValue();
                    String abilityId = RegistryInventory.ITEM_USE_ABILITY_MIAPI_REGISTRY.findKey(ability).toString();
                    if (abilityId == null) {
                        Miapi.LOGGER.error("Failed to encode ItemUseAbility: Ability not found in registry.");
                        continue;
                    }
                    DataResult keyResult = Codec.STRING.encode((Object)abilityId, ops, ops.empty());
                    if (keyResult.error().isPresent()) {
                        Miapi.LOGGER.error("Failed to encode ItemUseAbility key: " + ((DataResult.Error)keyResult.error().get()).message());
                        continue;
                    }
                    if (keyResult.result().isEmpty()) {
                        Miapi.LOGGER.error("Failed to encode ItemUseAbility key: " + abilityId);
                        continue;
                    }
                    DataResult valueResult = DataResult.success(ability.encodeObject(ops, data));
                    if (valueResult.error().isPresent()) {
                        Miapi.LOGGER.error("Failed to encode data for ability: " + abilityId + " - " + ((DataResult.Error)valueResult.error().get()).message());
                        continue;
                    }
                    encodedMap.put(keyResult.result().get(), valueResult.result().get());
                    map.add(keyResult.result().get(), valueResult.result().get());
                }
                return map.build(prefix);
            }

            public <T> DataResult<Pair<Map<ItemUseAbility<?>, Object>, T>> decode(DynamicOps<T> ops, T input) {
                LinkedHashMap abilityMap = new LinkedHashMap();
                DataResult map = ops.getMap(input);
                if (map.error().isPresent()) {
                    return DataResult.error(() -> ((DataResult.Error)map.error().get()).message());
                }
                ((Stream)ops.getMapValues(input).getOrThrow()).toList().forEach(pair -> {
                    String resourceLocation = (String)((Pair)Codec.STRING.decode(ops, pair.getFirst()).getOrThrow()).getFirst();
                    ItemUseAbility itemUseAbility = RegistryInventory.ITEM_USE_ABILITY_MIAPI_REGISTRY.get(resourceLocation);
                    if (itemUseAbility == null) {
                        Miapi.LOGGER.error("can not find ItemUseAbility " + resourceLocation);
                    } else {
                        Object data = itemUseAbility.decode(ops, pair.getSecond());
                        abilityMap.put(itemUseAbility, data);
                    }
                });
                return DataResult.success((Object)new Pair(abilityMap, input));
            }
        };
        OLD_CODEC = OLD_CODEC_RAW.xmap(a -> {
            ArrayList list = new ArrayList();
            a.forEach((itemUseAbility, object) -> list.add(new AbilityContext(Miapi.id("old_ability_system"), 0.0f, itemUseAbility, new DoubleOperationResolvable(1.0), new DoubleOperationResolvable(1.0), new DoubleOperationResolvable(1.0), object)));
            return list;
        }, b -> null);
        CODEC = Codec.withAlternative((Codec)AbilityContext.CODEC.listOf(), OLD_CODEC);
    }

    public static class AbilityContext<T>
    implements MergeAble<AbilityContext<T>>,
    InitializeAble<AbilityContext<T>> {
        public static final Map<ResourceLocation, MapCodec<? extends AbilityContext<?>>> ABILITY_CODECS = new ConcurrentHashMap();
        public static final Codec<AbilityContext<?>> CODEC = ResourceLocation.CODEC.dispatch(AbilityContext::abilityId, AbilityContext::getCodecForType);
        public final float priority;
        public final ResourceLocation id;
        public final ItemUseAbility<T> ability;
        public final T data;
        public final DoubleOperationResolvable allowedOnBlock;
        public final DoubleOperationResolvable allowedOnEntity;
        public final DoubleOperationResolvable allowedOnAir;

        public AbilityContext(ResourceLocation id, float priority, ItemUseAbility<T> ability, DoubleOperationResolvable allowedOnEntity, DoubleOperationResolvable allowedOnBlock, DoubleOperationResolvable allowedOnAir, Object data) {
            this.id = id;
            this.priority = priority;
            this.ability = ability;
            this.data = data;
            this.allowedOnBlock = allowedOnBlock;
            this.allowedOnEntity = allowedOnEntity;
            this.allowedOnAir = allowedOnAir;
        }

        public AbilityContext(ResourceLocation generatedMaterialAbility, float priority, ItemUseAbility<T> ability, Object itemContext) {
            this(generatedMaterialAbility, priority, ability, new DoubleOperationResolvable(1.0), new DoubleOperationResolvable(1.0), new DoubleOperationResolvable(1.0), itemContext);
        }

        public ResourceLocation abilityId() {
            return RegistryInventory.ITEM_USE_ABILITY_MIAPI_REGISTRY.findKey(this.ability);
        }

        private static MapCodec<? extends AbilityContext<?>> getCodecForType(ResourceLocation type) {
            MapCodec<? extends AbilityContext<?>> codec = ABILITY_CODECS.get(type);
            if (codec == null) {
                Miapi.LOGGER.error("No codec registered for ability type {}", (Object)type);
                return MapCodec.unit(new AbilityContext(type, 0.0f, null, null));
            }
            return codec;
        }

        public static <T> void registerAbilityCodec(ResourceLocation type, ItemUseAbility<T> ability) {
            MapCodec codec = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Miapi.ID_CODEC.fieldOf("id").forGetter(holder -> holder.id), (App)Codec.FLOAT.optionalFieldOf("priority", (Object)Float.valueOf(0.0f)).forGetter(holder -> Float.valueOf(holder.priority)), (App)DoubleOperationResolvable.CODEC.optionalFieldOf("allowed_on_entity", (Object)new DoubleOperationResolvable(1.0)).forGetter(holder -> holder.allowedOnEntity), (App)DoubleOperationResolvable.CODEC.optionalFieldOf("allowed_on_block", (Object)new DoubleOperationResolvable(1.0)).forGetter(holder -> holder.allowedOnBlock), (App)DoubleOperationResolvable.CODEC.optionalFieldOf("allowed_on_air", (Object)new DoubleOperationResolvable(1.0)).forGetter(holder -> holder.allowedOnAir), (App)ability.getCodec().fieldOf("data").forGetter(holder -> holder.data)).apply((Applicative)instance, (id, priority, allowedOnEntity, allowedOnBlock, allowedOnAir, data) -> new AbilityContext((ResourceLocation)id, priority.floatValue(), ability, (DoubleOperationResolvable)allowedOnEntity, (DoubleOperationResolvable)allowedOnBlock, (DoubleOperationResolvable)allowedOnAir, data)));
            ABILITY_CODECS.put(type, codec);
            Miapi.LOGGER.debug("Registered codec for ability type {}", (Object)type);
        }

        @Override
        public AbilityContext<T> initialize(AbilityContext<T> property, ModuleInstance context) {
            T initialized = this.ability.initialize(property.data, context);
            return new AbilityContext<T>(this.id, this.priority, this.ability, property.allowedOnEntity.initialize(context), this.allowedOnBlock.initialize(context), this.allowedOnAir.initialize(context), initialized);
        }

        public AbilityContext<?> mergeUnchecked(AbilityContext<?> left, AbilityContext<?> right, MergeType mergeType) {
            return this.merge(left, right, mergeType);
        }

        @Override
        public AbilityContext<T> merge(AbilityContext<T> left, AbilityContext<T> right, MergeType mergeType) {
            T merged = this.ability.merge(left.data, right.data, mergeType);
            return new AbilityContext<T>(this.id, Math.max(left.priority, right.priority), this.ability, DoubleOperationResolvable.merge(left.allowedOnEntity, right.allowedOnEntity, mergeType), DoubleOperationResolvable.merge(left.allowedOnBlock, right.allowedOnBlock, mergeType), DoubleOperationResolvable.merge(left.allowedOnAir, right.allowedOnAir, mergeType), merged);
        }

        public String toString() {
            return "AbilityHolder{id=" + String.valueOf(this.id) + ", type=" + String.valueOf(this.abilityId()) + ", priority=" + this.priority + ", data=" + String.valueOf(this.data) + "}";
        }
    }
}

