/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities.util;

import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class AttackUtil {
    public static void performAttack(Player player, LivingEntity target, float damage, boolean useEnchants, ItemStack causing) {
        DamageSource source = player.damageSources().playerAttack(player);
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (target.hurt(source, damage) && useEnchants) {
                EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)level2, (Entity)target, (DamageSource)source, (ItemStack)causing);
            }
        }
    }

    public static void performSweeping(Player player, LivingEntity target, float sweepingRange, float sweepingDamage) {
        Level world = player.level();
        List entities = world.getEntitiesOfClass(LivingEntity.class, target.getBoundingBox().inflate(1.0, 0.25, 1.0).inflate((double)(sweepingRange * 2.0f), 1.0, (double)(sweepingRange * 2.0f)));
        for (LivingEntity entity : entities) {
            ArmorStand armorStandEntity;
            if (entity == player || entity == target || player.isAlliedTo((Entity)entity) || entity instanceof ArmorStand && (armorStandEntity = (ArmorStand)entity).isMarker() || !(player.distanceToSqr((Entity)entity) < (double)(sweepingRange * sweepingRange))) continue;
            entity.knockback(0.4, (double)Mth.sin((float)(player.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(player.getYRot() * ((float)Math.PI / 180)))));
            entity.hurt(player.damageSources().playerAttack(player), sweepingDamage);
        }
        world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, player.getSoundSource(), 1.0f, 1.0f);
        player.sweepAttack();
    }

    public static EntityHitResult raycastFromPlayer(double maxDistance, Player player) {
        Vec3 start = player.getEyePosition(0.0f);
        Vec3 vec3d2 = player.getViewVector(0.0f);
        Vec3 end = start.add(vec3d2.x * maxDistance, vec3d2.y * maxDistance, vec3d2.z * maxDistance);
        AABB box = player.getBoundingBox().expandTowards(vec3d2.scale(maxDistance)).inflate(1.0, 1.0, 1.0);
        return ProjectileUtil.getEntityHitResult((Entity)player, (Vec3)start, (Vec3)end, (AABB)box, entityx -> !entityx.isSpectator() && entityx.isPickable(), (double)(maxDistance * maxDistance));
    }
}

