/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities.util;

import com.mojang.serialization.Codec;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.platform.Platform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.modules.abilities.key.KeyBindAbilityManagerProperty;
import smartin.miapi.modules.abilities.key.KeyBindFacet;
import smartin.miapi.modules.abilities.util.AbilityHolder;
import smartin.miapi.modules.abilities.util.AbilityMangerProperty;
import smartin.miapi.modules.abilities.util.AbilityProperty;
import smartin.miapi.modules.abilities.util.ItemUseAbility;
import smartin.miapi.modules.abilities.util.ItemUseDefaultCooldownAbility;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.registries.MiapiRegistry;
import smartin.miapi.registries.RegistryInventory;

public class ItemAbilityManager {
    private static final Map<Player, ItemStack> playerActiveItems = new WeakHashMap<Player, ItemStack>();
    private static final Map<Player, ItemStack> playerActiveItemsClient = new WeakHashMap<Player, ItemStack>();
    public static final MiapiRegistry<ItemUseAbility> useAbilityRegistry = MiapiRegistry.getInstance(ItemUseAbility.class);
    private static final AbilityHolder<?> emptyAbility = new AbilityHolder<Object>(new EmptyAbility(), new Object());
    private static final Map<ItemStack, AbilityHolder<?>> abilityMap = Collections.synchronizedMap(new WeakHashMap());
    public static final Map<Player, ResourceLocation> clientKeyBindID = new WeakHashMap<Player, ResourceLocation>();
    public static final Map<Player, ResourceLocation> serverKeyBindID = new WeakHashMap<Player, ResourceLocation>();

    public static void setup() {
        TickEvent.PLAYER_PRE.register(playerEntity -> {
            Map<Player, ItemStack> activeItems = playerActiveItems;
            if (playerEntity.level().isClientSide) {
                activeItems = playerActiveItemsClient;
            }
            ItemStack oldItem = activeItems.get(playerEntity);
            ItemStack playerItem = playerEntity.getUseItem();
            if (playerItem != null && !playerItem.equals(oldItem)) {
                activeItems.put((Player)playerEntity, playerItem);
                if (oldItem != null) {
                    AbilityHolder<?> holder = ItemAbilityManager.getAbility(oldItem);
                    holder.onStoppedHolding(oldItem, playerEntity.level(), (LivingEntity)playerEntity);
                    ItemAbilityManager.clearAbility(oldItem);
                }
            }
        });
        useAbilityRegistry.addCallback(ability -> ModularItemCache.setSupplier(AbilityMangerProperty.KEY + "_" + String.valueOf(RegistryInventory.ITEM_USE_ABILITY_MIAPI_REGISTRY.findKey((ItemUseAbility)ability)), itemStack -> {
            AbilityHolder<?> optional = abilityMap.get(itemStack);
            if (optional != null && optional.ability().equals(ability)) {
                return optional.context();
            }
            return null;
        }));
        useAbilityRegistry.register(Miapi.id("empty"), emptyAbility.ability());
    }

    public static AbilityHolder<?> getEmpty() {
        return emptyAbility;
    }

    private static AbilityHolder<?> getAbility(ItemStack itemStack) {
        AbilityHolder<?> useAbility = abilityMap.get(itemStack);
        return useAbility == null ? emptyAbility : useAbility;
    }

    public static List<AbilityHolder<?>> getAbilities(ItemStack itemStack) {
        ArrayList result = new ArrayList();
        AbilityProperty.property.getData(itemStack).ifPresent(list -> list.forEach(context -> result.add(context.ability.getAsHolder(context.data))));
        Map keyboundAbilities = KeyBindAbilityManagerProperty.property.getData(itemStack).orElse(new HashMap());
        for (List list2 : keyboundAbilities.values()) {
            list2.forEach(context -> result.add(context.ability.getAsHolder(context.data)));
        }
        return result;
    }

    private static AbilityHolder<?> getAbility(ItemStack itemStack, Level world, Player player, InteractionHand hand, AbilityHitContext abilityHitContext) {
        ResourceLocation keybindID = null;
        keybindID = player.level().isClientSide ? clientKeyBindID.get(player) : serverKeyBindID.get(player);
        if (keybindID == null) {
            AbilityHolder abilityHolder = AbilityProperty.property.getData(itemStack).flatMap(list -> list.stream().filter(abilityContext -> {
                if (abilityHitContext.hitEntity() != null && abilityContext.allowedOnEntity.isTrue()) {
                    return true;
                }
                if (abilityContext.allowedOnBlock.isTrue() && abilityHitContext.hitEntity() == null && abilityHitContext.hitResult() != null && abilityHitContext.hitResult().getClickedPos() != null) {
                    return true;
                }
                return abilityContext.allowedOnAir.isTrue() && abilityHitContext.hitEntity() == null && abilityHitContext.hitResult() == null;
            }).map(abilityContext -> abilityContext.ability.getAsHolder(abilityContext.data)).filter(ability -> ability.allowedOnItem(itemStack, world, player, hand, abilityHitContext)).findFirst()).orElse(null);
            if (abilityHolder != null) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    KeyBindFacet.get(serverPlayer).reset(serverPlayer);
                }
                ItemAbilityManager.setCurrentAbility(itemStack, abilityHolder);
                return abilityHolder;
            }
        } else {
            Map map = KeyBindAbilityManagerProperty.property.getData(itemStack).orElse(new LinkedHashMap());
            AbilityHolder abilityHolder = Optional.ofNullable((List)map.get(keybindID)).flatMap(list -> list.stream().filter(abilityContext -> {
                if (abilityHitContext.hitEntity() != null && abilityContext.allowedOnEntity.isTrue()) {
                    return true;
                }
                if (abilityContext.allowedOnBlock.isTrue() && abilityHitContext.hitEntity() == null && abilityHitContext.hitResult() != null && abilityHitContext.hitResult().getClickedPos() != null) {
                    return true;
                }
                return abilityContext.allowedOnAir.isTrue() && abilityHitContext.hitEntity() == null && abilityHitContext.hitResult() == null;
            }).map(abilityContext -> abilityContext.ability.getAsHolder(abilityContext.data)).filter(ability -> ability.allowedOnItem(itemStack, world, player, hand, abilityHitContext)).findFirst()).orElse(null);
            if (abilityHolder != null) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    KeyBindFacet.get(serverPlayer).reset(serverPlayer);
                }
                ItemAbilityManager.setCurrentAbility(itemStack, abilityHolder);
                return abilityHolder;
            }
        }
        ItemAbilityManager.clearAbility(itemStack);
        return emptyAbility;
    }

    @Nullable
    private static AbilityHolder<?> setCurrentAbility(ItemStack itemStack, AbilityHolder<?> abilityHolder) {
        ModularItemCache.clear(itemStack, AbilityMangerProperty.KEY + "_" + String.valueOf(RegistryInventory.ITEM_USE_ABILITY_MIAPI_REGISTRY.findKey(abilityHolder.ability())));
        return abilityMap.put(itemStack, abilityHolder);
    }

    private static AbilityHolder<?> clearAbility(ItemStack oldItem) {
        AbilityHolder<?> abilityHolder = abilityMap.remove(oldItem);
        if (abilityHolder != null) {
            ModularItemCache.clear(oldItem, AbilityMangerProperty.KEY + "_" + String.valueOf(RegistryInventory.ITEM_USE_ABILITY_MIAPI_REGISTRY.findKey(abilityHolder.ability())));
        }
        return abilityHolder;
    }

    public static UseAnim getUseAction(ItemStack itemStack, Supplier<UseAnim> getItem) {
        AbilityHolder<?> ability = ItemAbilityManager.getAbility(itemStack);
        if (emptyAbility.equals(ability)) {
            return getItem.get();
        }
        return ability.getUseAction(itemStack);
    }

    public static int getMaxUseTime(ItemStack itemStack, LivingEntity livingEntity, Supplier<Integer> getItem) {
        AbilityHolder<?> ability = ItemAbilityManager.getAbility(itemStack);
        if (emptyAbility.equals(ability)) {
            return getItem.get();
        }
        return ability.getMaxUseTime(itemStack, livingEntity);
    }

    public static InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand, Supplier<InteractionResultHolder<ItemStack>> getItem) {
        ItemStack itemStack = user.getItemInHand(hand);
        AbilityHolder<?> ability = ItemAbilityManager.getAbility(itemStack, world, user, hand, new AbilityHitContext(){

            @Override
            @Nullable
            public UseOnContext hitResult() {
                return null;
            }

            @Override
            @Nullable
            public Entity hitEntity() {
                return null;
            }
        });
        ItemAbilityManager.setCurrentAbility(itemStack, ability);
        if (emptyAbility.equals(ability)) {
            return getItem.get();
        }
        return ability.use(world, user, hand);
    }

    public static ItemStack finishUsing(ItemStack stack, Level world, LivingEntity user, Supplier<ItemStack> getItem) {
        AbilityHolder<?> ability = ItemAbilityManager.getAbility(stack);
        if (emptyAbility.equals(ability)) {
            ItemAbilityManager.clearAbility(stack);
            return getItem.get();
        }
        ItemStack itemStack = ability.finishUsing(stack, world, user);
        ItemAbilityManager.clearAbility(stack);
        return itemStack;
    }

    public static void onStoppedUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks, Runnable getItem) {
        AbilityHolder<?> ability = ItemAbilityManager.getAbility(stack);
        if (emptyAbility.equals(ability)) {
            getItem.run();
            return;
        }
        ability.onStoppedUsing(stack, world, user, remainingUseTicks);
        ItemUseAbility<?> itemUseAbility = ability.ability();
        if (itemUseAbility instanceof ItemUseDefaultCooldownAbility) {
            ItemUseDefaultCooldownAbility itemUseDefaultCooldownAbility = (ItemUseDefaultCooldownAbility)itemUseAbility;
            itemUseDefaultCooldownAbility.afterStopAbility(stack, world, user, remainingUseTicks);
        }
        ItemAbilityManager.clearAbility(stack);
    }

    public static void usageTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks, Runnable getItem) {
        AbilityHolder<?> ability = ItemAbilityManager.getAbility(stack);
        if (emptyAbility.equals(ability)) {
            ItemAbilityManager.clearAbility(stack);
            getItem.run();
            return;
        }
        ability.usageTick(world, user, stack, remainingUseTicks);
    }

    public static boolean useOnRelease(ItemStack stack, Supplier<Boolean> getItem) {
        AbilityHolder<?> ability = ItemAbilityManager.getAbility(stack);
        if (emptyAbility.equals(ability)) {
            ItemAbilityManager.clearAbility(stack);
            return getItem.get();
        }
        return ability.useOnRelease(stack);
    }

    public static InteractionResult useOnEntity(ItemStack stack, Player user, final LivingEntity entity, InteractionHand hand, Supplier<InteractionResult> getItem) {
        AbilityHolder<?> ability = ItemAbilityManager.getAbility(stack, user.level(), user, hand, new AbilityHitContext(){

            @Override
            @Nullable
            public UseOnContext hitResult() {
                return null;
            }

            @Override
            @Nullable
            public Entity hitEntity() {
                return entity;
            }
        });
        if (emptyAbility.equals(ability)) {
            return getItem.get();
        }
        ItemAbilityManager.setCurrentAbility(stack, ability);
        return ItemAbilityManager.getAbility(stack).useOnEntity(stack, user, entity, hand);
    }

    public static InteractionResult useOnBlock(final UseOnContext context, Supplier<InteractionResult> getItem) {
        AbilityHolder<?> ability = ItemAbilityManager.getAbility(context.getItemInHand(), context.getLevel(), context.getPlayer(), context.getHand(), new AbilityHitContext(){

            @Override
            @Nullable
            public UseOnContext hitResult() {
                return context;
            }

            @Override
            @Nullable
            public Entity hitEntity() {
                return null;
            }
        });
        if (emptyAbility.equals(ability)) {
            return getItem.get();
        }
        ItemAbilityManager.setCurrentAbility(context.getItemInHand(), ability);
        if (Platform.isForgeLike()) {
            InteractionResult result = ItemAbilityManager.getAbility(context.getItemInHand()).useOnBlock(context);
            if (result.equals((Object)InteractionResult.PASS)) {
                return getItem.get();
            }
            return result;
        }
        AbilityHolder<?> executing = ItemAbilityManager.getAbility(context.getItemInHand());
        return executing.useOnBlock(context);
    }

    public static interface AbilityHitContext {
        @Nullable
        public UseOnContext hitResult();

        @Nullable
        public Entity hitEntity();
    }

    static class EmptyAbility
    implements ItemUseAbility {
        EmptyAbility() {
        }

        public boolean allowedOnItem(ItemStack itemStack, Level world, Player player, InteractionHand hand, AbilityHitContext abilityHitContext, Object context) {
            return true;
        }

        public UseAnim getUseAction(ItemStack itemStack, Object context) {
            return UseAnim.NONE;
        }

        public int getMaxUseTime(ItemStack itemStack, LivingEntity entity, Object context) {
            return 0;
        }

        public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand, Object context) {
            return InteractionResultHolder.pass((Object)user.getItemInHand(hand));
        }

        public Codec getCodec() {
            return AutoCodec.of(EmptyAbility.class).codec();
        }
    }
}

