/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities.util;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import io.netty.handler.codec.DecoderException;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.abilities.util.AbilityHolder;
import smartin.miapi.modules.abilities.util.AbilityMangerProperty;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.properties.util.InitializeAble;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.registries.RegistryInventory;

public interface ItemUseAbility<T>
extends MergeAble<T>,
InitializeAble<T> {
    public boolean allowedOnItem(ItemStack var1, Level var2, Player var3, InteractionHand var4, ItemAbilityManager.AbilityHitContext var5, T var6);

    public UseAnim getUseAction(ItemStack var1, T var2);

    public int getMaxUseTime(ItemStack var1, LivingEntity var2, T var3);

    public InteractionResultHolder<ItemStack> use(Level var1, Player var2, InteractionHand var3, T var4);

    default public ItemStack finishUsing(ItemStack stack, Level world, LivingEntity user, T context) {
        return stack;
    }

    default public void onStoppedUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks, T context) {
    }

    default public boolean useOnRelease(ItemStack itemStack, T context) {
        return false;
    }

    default public void onStoppedHolding(ItemStack stack, Level world, LivingEntity user, T context) {
    }

    default public EquipmentSlot getEquipmentSlot(InteractionHand hand) {
        return hand.equals((Object)InteractionHand.MAIN_HAND) ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
    }

    default public InteractionResult useOnEntity(ItemStack stack, Player user, LivingEntity entity, InteractionHand hand, T context) {
        return InteractionResult.PASS;
    }

    default public InteractionResult useOnBlock(UseOnContext context, T abilityContext) {
        return InteractionResult.PASS;
    }

    default public void usageTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks, T context) {
    }

    public Codec<T> getCodec();

    default public <K> T decode(DynamicOps<K> ops, K prefix) {
        return (T)((Pair)this.getCodec().decode(ops, prefix).getOrThrow(s -> new DecoderException("Could not decode Ability " + this.getClass().getName() + " with error" + s))).getFirst();
    }

    default public <K> K encode(DynamicOps<K> ops, T input) {
        return (K)this.getCodec().encodeStart(ops, input).getOrThrow(s -> new DecoderException("Could not encode Ability " + this.getClass().getName() + " with error" + s));
    }

    default public T getDefaultContext() {
        return null;
    }

    default public <K> K encodeObject(DynamicOps<K> ops, Object input) {
        return this.encode(ops, this.castTo(input));
    }

    @Override
    default public T initialize(T data, ModuleInstance moduleInstance) {
        return data;
    }

    @Override
    default public T merge(T left, T right, MergeType mergeType) {
        return MergeAble.decideLeftRight(left, right, mergeType);
    }

    @Nullable
    default public T getSpecialContext(ItemStack itemStack) {
        return this.getSpecialContext(itemStack, this.getDefaultContext());
    }

    @Nullable
    default public T getSpecialContext(ItemStack itemStack, T defaultValue) {
        return ModularItemCache.get(itemStack, AbilityMangerProperty.KEY + "_" + String.valueOf(RegistryInventory.ITEM_USE_ABILITY_MIAPI_REGISTRY.findKey(this)), defaultValue);
    }

    default public T castTo(Object object) {
        return (T)object;
    }

    default public AbilityHolder<T> getAsHolder(Object context) {
        return new AbilityHolder<Object>(this, context);
    }
}

