/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities.util;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import smartin.miapi.modules.abilities.util.ItemUseAbility;

public interface ItemUseMinHoldAbility<T>
extends ItemUseAbility<T> {
    public int getMinHoldTime(ItemStack var1);

    @Override
    default public void onStoppedUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks, T context) {
        if (this.finishedMinHold(stack, world, user, remainingUseTicks, context)) {
            this.onStoppedUsingAfter(stack, world, user, remainingUseTicks, context);
        }
    }

    default public boolean finishedMinHold(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks, T context) {
        return this.getMaxUseTime(stack, user, context) - remainingUseTicks > this.getMinHoldTime(stack);
    }

    default public void onStoppedUsingAfter(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks, T context) {
    }
}

