/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities.util;

import com.mojang.serialization.MapCodec;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.abilities.util.MinMaxCDAbility;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

public abstract class ToolAbilities
extends MinMaxCDAbility<ToolAbilityContext> {
    public static MapCodec<ToolAbilityContext> CODEC = AutoCodec.of(ToolAbilityContext.class);

    public ToolAbilities() {
        super(0, 0);
    }

    @Override
    public boolean allowedOnItem(ItemStack itemStack, Level world, Player player, InteractionHand hand, ItemAbilityManager.AbilityHitContext abilityHitContext, MinMaxCDAbility.MinMaxCDData<ToolAbilityContext> context) {
        return abilityHitContext.hitResult() != null;
    }

    @Override
    public UseAnim getUseAction(ItemStack itemStack, MinMaxCDAbility.MinMaxCDData<ToolAbilityContext> context) {
        return UseAnim.NONE;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand, MinMaxCDAbility.MinMaxCDData<ToolAbilityContext> context) {
        return null;
    }

    public abstract Optional<BlockState> getBlockState(BlockState var1, UseOnContext var2);

    @Override
    public InteractionResult useOnBlock(UseOnContext context, MinMaxCDAbility.MinMaxCDData<ToolAbilityContext> abilityContext) {
        Level world = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        Player playerEntity = context.getPlayer();
        BlockState blockState = world.getBlockState(blockPos);
        Optional<BlockState> changedBlock = this.getBlockState(blockState, context);
        if (changedBlock.isPresent()) {
            if (playerEntity instanceof ServerPlayer) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)playerEntity, blockPos, context.getItemInHand());
            }
            world.setBlock(blockPos, changedBlock.get(), 11);
            world.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockPos, GameEvent.Context.of((Entity)playerEntity, (BlockState)changedBlock.get()));
            if (playerEntity != null) {
                EquipmentSlot equipmentSlot = context.getHand().equals((Object)InteractionHand.MAIN_HAND) ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
                context.getItemInHand().hurtAndBreak(1, (LivingEntity)playerEntity, equipmentSlot);
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return InteractionResult.PASS;
    }

    @Override
    public ToolAbilityContext mergeData(ToolAbilityContext left, ToolAbilityContext right, MergeType mergeType) {
        return MergeAble.decideLeftRight(left, right, mergeType);
    }

    @Override
    public ToolAbilityContext initializeData(ToolAbilityContext property, ModuleInstance moduleInstance) {
        return property;
    }

    @Override
    public MapCodec<ToolAbilityContext> getMapCodec() {
        return CODEC;
    }

    public static class ToolAbilityContext {
    }
}

