/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.action;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class ActionContext {
    private static final Map<Class<?>, Supplier<TypeManager<?>>> TYPE_MANAGER_REGISTRY = new HashMap();
    private final Map<Class<?>, TypeManager<?>> instanceTypeManagers = new HashMap();
    public ServerLevel level;
    public Player contextPlayer;
    public ItemStack contextItem;

    public <T> void addListSupplier(Class<T> type, String key, Supplier<List<T>> listSupplier) {
        this.getTypeManager(type).putListSupplier(key, listSupplier, this);
    }

    public <T> void addObjectSupplier(Class<T> type, String key, Supplier<T> objectSupplier) {
        this.getTypeManager(type).putObjectSupplier(key, objectSupplier, this);
    }

    public <T> Optional<List<T>> getList(Class<T> type, String key) {
        return this.getTypeManager(type).getList(key, this);
    }

    public <T> Optional<T> getObject(Class<T> type, String key) {
        return this.getTypeManager(type).getObject(key, this);
    }

    public <T> TypeManager<T> getTypeManager(Class<T> type) {
        return this.instanceTypeManagers.computeIfAbsent(type, t -> {
            Supplier<TypeManager> supplier = TYPE_MANAGER_REGISTRY.getOrDefault(t, DefaultTypeManager::new);
            return supplier.get();
        });
    }

    public static <T> void registerTypeManager(Class<T> type, Supplier<TypeManager<?>> managerSupplier) {
        TYPE_MANAGER_REGISTRY.put(type, managerSupplier);
    }

    static {
        ActionContext.registerTypeManager(Entity.class, EntityTypeManager::new);
        ActionContext.registerTypeManager(Vec3.class, Vec3TypeManager::new);
    }

    public static interface TypeManager<T> {
        public void putListSupplier(String var1, Supplier<List<T>> var2, ActionContext var3);

        public void putObjectSupplier(String var1, Supplier<T> var2, ActionContext var3);

        public Optional<List<T>> getList(String var1, ActionContext var2);

        public Optional<T> getObject(String var1, ActionContext var2);
    }

    public static class Vec3TypeManager
    extends DefaultTypeManager<Vec3> {
        @Override
        public void putObjectSupplier(String key, Supplier<Vec3> vectorSupplier, ActionContext actionContext) {
            super.putObjectSupplier(key, vectorSupplier, actionContext);
            this.addComponentSuppliers(key, vectorSupplier, actionContext);
        }

        @Override
        public void putListSupplier(String key, Supplier<List<Vec3>> vectorListSupplier, ActionContext actionContext) {
            super.putListSupplier(key, vectorListSupplier, actionContext);
            vectorListSupplier.get().forEach(v -> this.addComponentSuppliers(key, () -> v, actionContext));
        }

        private void addComponentSuppliers(String key, Supplier<Vec3> vectorSupplier, ActionContext actionContext) {
            actionContext.addObjectSupplier(Float.class, key + ".x", () -> Float.valueOf((float)((Vec3)vectorSupplier.get()).x));
            actionContext.addObjectSupplier(Float.class, key + ".y", () -> Float.valueOf((float)((Vec3)vectorSupplier.get()).y));
            actionContext.addObjectSupplier(Float.class, key + ".z", () -> Float.valueOf((float)((Vec3)vectorSupplier.get()).z));
        }
    }

    public static class EntityTypeManager
    extends DefaultTypeManager<Entity> {
        @Override
        public void putObjectSupplier(String key, Supplier<Entity> entitySupplier, ActionContext actionContext) {
            super.putObjectSupplier(key, entitySupplier, actionContext);
            actionContext.addObjectSupplier(Vec3.class, key, () -> ((Entity)entitySupplier.get()).position());
        }

        @Override
        public void putListSupplier(String key, Supplier<List<Entity>> entityListSupplier, ActionContext actionContext) {
            super.putListSupplier(key, entityListSupplier, actionContext);
            actionContext.addListSupplier(Vec3.class, key, () -> ((List)entityListSupplier.get()).stream().map(Entity::position).toList());
        }
    }

    public static class DefaultTypeManager<T>
    implements TypeManager<T> {
        private final Map<String, Supplier<List<T>>> listSupplierMap = new HashMap<String, Supplier<List<T>>>();
        private final Map<String, Supplier<T>> objectSupplierMap = new HashMap<String, Supplier<T>>();

        @Override
        public void putListSupplier(String key, Supplier<List<T>> listSupplier, ActionContext actionContext) {
            this.listSupplierMap.put(key, listSupplier);
        }

        @Override
        public void putObjectSupplier(String key, Supplier<T> objectSupplier, ActionContext actionContext) {
            this.objectSupplierMap.put(key, objectSupplier);
        }

        @Override
        public Optional<List<T>> getList(String key, ActionContext actionContext) {
            Supplier<List<T>> supplier = this.listSupplierMap.get(key);
            return supplier != null ? Optional.ofNullable(supplier.get()) : Optional.empty();
        }

        @Override
        public Optional<T> getObject(String key, ActionContext actionContext) {
            Supplier<T> supplier = this.objectSupplierMap.get(key);
            return supplier != null ? Optional.ofNullable(supplier.get()) : Optional.empty();
        }
    }
}

