/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.action.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import smartin.miapi.Miapi;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.action.ActionContext;
import smartin.miapi.modules.action.ActionEffect;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;

public record DamageActionEffect(String sourceKey, String targetKey, boolean useWeaponOnHit, boolean useEnchants, Optional<String> item, DoubleOperationResolvable value, ResourceLocation type) implements ActionEffect
{
    public static final ResourceLocation TYPE = Miapi.id("damage_action_effect");
    public static final Codec<DamageActionEffect> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("source").forGetter(DamageActionEffect::sourceKey), (App)Codec.STRING.fieldOf("target").forGetter(DamageActionEffect::targetKey), (App)Miapi.FIXED_BOOL_CODEC.optionalFieldOf("use_weapon_effects", (Object)true).forGetter(DamageActionEffect::useWeaponOnHit), (App)Miapi.FIXED_BOOL_CODEC.optionalFieldOf("use_enchants", (Object)true).forGetter(DamageActionEffect::useEnchants), (App)Codec.STRING.optionalFieldOf("item").forGetter(DamageActionEffect::item), (App)DoubleOperationResolvable.CODEC.fieldOf("damage").forGetter(DamageActionEffect::value), (App)ResourceLocation.CODEC.fieldOf("type").orElse((Object)TYPE).forGetter(DamageActionEffect::type)).apply((Applicative)instance, DamageActionEffect::new));

    @Override
    public List<String> dependency(ActionContext context) {
        return List.of(this.sourceKey, this.targetKey);
    }

    @Override
    public boolean setup(ActionContext context) {
        boolean sourceExists = context.getObject(Entity.class, this.sourceKey).isPresent();
        boolean targetsExist = context.getList(Entity.class, this.targetKey).isPresent();
        return sourceExists && targetsExist;
    }

    @Override
    public void execute(ActionContext context) {
        Optional<ItemStack> opt;
        Optional<Entity> sourceOpt = context.getObject(Entity.class, this.sourceKey);
        Optional<List<Entity>> targetsOpt = context.getList(Entity.class, this.targetKey);
        ItemStack itemStack = context.contextItem;
        if (this.item.isPresent() && (opt = context.getObject(ItemStack.class, this.item().get())).isPresent()) {
            itemStack = opt.get();
        }
        if (sourceOpt.isPresent() && targetsOpt.isPresent()) {
            Entity sourceEntity = sourceOpt.get();
            List<Entity> targetEntities = targetsOpt.get();
            Holder damageType = (Holder)((Registry)context.level.registryAccess().registry(Registries.DAMAGE_TYPE).get()).getHolder(this.type).get();
            DamageSource damageSource = new DamageSource(damageType, sourceEntity);
            for (Entity targetEntity : targetEntities) {
                float bonusDamage = 0.0f;
                if (this.useEnchants() && itemStack != null) {
                    if (sourceEntity instanceof Player) {
                        Player player = (Player)sourceEntity;
                        if (targetEntity instanceof LivingEntity) {
                            LivingEntity livingTarget = (LivingEntity)targetEntity;
                            itemStack.hurtEnemy(livingTarget, player);
                        }
                    }
                    bonusDamage = itemStack.getItem().getAttackDamageBonus(targetEntity, (float)this.value().getValue(), damageSource);
                }
                if (this.useEnchants()) {
                    bonusDamage += EnchantmentHelper.modifyDamage((ServerLevel)context.level, (ItemStack)itemStack, (Entity)targetEntity, (DamageSource)damageSource, (float)((float)this.value().getValue()));
                }
                targetEntity.hurt(damageSource, (float)this.value().getValue() + bonusDamage);
                if (!this.useEnchants()) continue;
                EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)context.level, (Entity)sourceEntity, (DamageSource)damageSource, (ItemStack)itemStack);
            }
        }
    }

    @Override
    public DamageActionEffect initialize(ModuleInstance moduleInstance) {
        return new DamageActionEffect(this.sourceKey(), this.targetKey(), this.useWeaponOnHit(), this.useEnchants(), this.item(), this.value().initialize(moduleInstance), this.type());
    }

    @Override
    public ResourceLocation getType() {
        return TYPE;
    }
}

