/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.action.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import smartin.miapi.Miapi;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.action.ActionContext;
import smartin.miapi.modules.action.ActionEffect;

public record ExecuteCommandBlockPos(String command, String key, ResourceLocation type) implements ActionEffect
{
    public static final ResourceLocation TYPE = Miapi.id("execute_command_pos");
    public static final Codec<ExecuteCommandBlockPos> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("command").forGetter(ExecuteCommandBlockPos::command), (App)Codec.STRING.fieldOf("at").forGetter(ExecuteCommandBlockPos::key), (App)ResourceLocation.CODEC.fieldOf("type").orElse((Object)TYPE).forGetter(ExecuteCommandBlockPos::type)).apply((Applicative)instance, ExecuteCommandBlockPos::new));

    @Override
    public List<String> dependency(ActionContext context) {
        return List.of(this.key);
    }

    @Override
    public boolean setup(ActionContext context) {
        return context.getObject(BlockPos.class, this.key).isPresent();
    }

    @Override
    public void execute(ActionContext context) {
        Optional<List<BlockPos>> posOpt = context.getList(BlockPos.class, this.key);
        posOpt.ifPresent(posList -> posList.forEach(pos -> context.level.getServer().getCommands().performCommand(null, "execute positioned " + pos.getX() + " " + pos.getY() + " " + pos.getZ() + " " + this.command)));
    }

    @Override
    public ExecuteCommandBlockPos initialize(ModuleInstance moduleInstance) {
        return this;
    }

    @Override
    public ResourceLocation getType() {
        return TYPE;
    }
}

