/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.conditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientAdvancements;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.mixin.client.ClientAdvancementManagerAccessor;
import smartin.miapi.modules.conditions.ConditionManager;
import smartin.miapi.modules.conditions.ModuleCondition;

public class AdvancementCondition
implements ModuleCondition {
    public static Codec<AdvancementCondition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("advancement").forGetter(condition -> condition.advancement), (App)ComponentSerialization.CODEC.optionalFieldOf("error", (Object)Component.literal((String)"Unavailable.")).forGetter(condition -> condition.error)).apply((Applicative)instance, AdvancementCondition::new));
    public ResourceLocation advancement;
    public Component error;

    public AdvancementCondition(ResourceLocation perms, Component error) {
        this.advancement = perms;
        this.error = error;
    }

    @Override
    public boolean isAllowed(ConditionManager.ConditionContext conditionContext) {
        Optional<Player> playerOptional = conditionContext.getContext(ConditionManager.PLAYER_CONTEXT);
        if (playerOptional.isPresent()) {
            AdvancementHolder advancement1;
            Player player = playerOptional.get();
            List<Component> reasons = conditionContext.failReasons;
            if (this.advancement != null && (advancement1 = this.getAdvancement(this.advancement)) != null) {
                return AdvancementCondition.hasAdvancement(advancement1, player);
            }
            reasons.add(this.error);
        }
        return false;
    }

    @Override
    public ResourceLocation getID() {
        return Miapi.id("advancement");
    }

    public static boolean hasAdvancement(AdvancementHolder advancement, Player player) {
        if (Environment.isClient()) {
            return AdvancementCondition.hasAdvancementClient(advancement, player);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)player;
            return serverPlayerEntity.getAdvancements().getOrStartProgress(advancement).isDone();
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean hasAdvancementClient(AdvancementHolder advancement, Player player) {
        if (Minecraft.getInstance() != null && Minecraft.getInstance().getConnection() != null) {
            ClientAdvancements manager = Minecraft.getInstance().getConnection().getAdvancements();
            Map<AdvancementHolder, AdvancementProgress> map = ((ClientAdvancementManagerAccessor)manager).getProgress();
            Optional<AdvancementHolder> optional = map.keySet().stream().filter(advancement1 -> advancement.id().equals((Object)advancement1.id())).findFirst();
            return optional.isPresent() && map.get(optional.get()).isDone();
        }
        return false;
    }

    public AdvancementHolder getAdvancement(ResourceLocation identifier) {
        if (Environment.isClient()) {
            return this.getAdvancementClient(identifier);
        }
        if (Miapi.server != null) {
            return Miapi.server.getAdvancements().get(identifier);
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AdvancementHolder getAdvancementClient(ResourceLocation identifier) {
        AdvancementNode node;
        if (Minecraft.getInstance().getConnection() != null && (node = Minecraft.getInstance().getConnection().getAdvancements().getTree().get(identifier)) != null) {
            return node.holder();
        }
        return null;
    }
}

