/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.conditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceLocation;
import smartin.miapi.Miapi;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.conditions.ConditionManager;
import smartin.miapi.modules.conditions.ModuleCondition;

public class MaterialCountCondition
implements ModuleCondition {
    public static Codec<MaterialCountCondition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("material").forGetter(condition -> condition.material), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(condition -> condition.count), (App)ComponentSerialization.CODEC.optionalFieldOf("error", (Object)Component.translatable((String)"miapi.condition.material.error")).forGetter(condition -> condition.error)).apply((Applicative)instance, MaterialCountCondition::new));
    public String material = "";
    public int count;
    public Component error;

    public MaterialCountCondition(String material, int count, Component error) {
        this.material = material;
        this.count = count;
        this.error = error;
    }

    @Override
    public boolean isAllowed(ConditionManager.ConditionContext conditionContext) {
        Optional<ModuleInstance> optional = conditionContext.getContext(ConditionManager.MODULE_CONDITION_CONTEXT);
        if (optional.isPresent()) {
            ModuleInstance moduleInstance = optional.get();
            Material material1 = MaterialProperty.MATERIAL_REGISTRY.get(this.material);
            if (material1 != null && this.count >= this.getCount(moduleInstance, material1)) {
                return true;
            }
        }
        conditionContext.failReasons.add((Component)Component.translatable((String)"miapi.condition.material.error"));
        return false;
    }

    public int getCount(ModuleInstance moduleInstance, Material material) {
        if (moduleInstance != null) {
            List<ModuleInstance> moduleInstances = moduleInstance.getRoot().allSubModules().stream().filter(moduleInstance1 -> material.equals(MaterialProperty.getMaterial(moduleInstance1))).toList();
            return moduleInstances.size();
        }
        return 0;
    }

    @Override
    public ResourceLocation getID() {
        return Miapi.id("material_count");
    }
}

