/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.conditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceLocation;
import smartin.miapi.Miapi;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.conditions.ConditionManager;
import smartin.miapi.modules.conditions.ModuleCondition;

public record NumberCondition(String condition, Component error) implements ModuleCondition
{
    public static Codec<NumberCondition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("condition").forGetter(NumberCondition::condition), (App)ComponentSerialization.CODEC.optionalFieldOf("error", (Object)Component.translatable((String)"miapi.error")).forGetter(condition -> condition.error)).apply((Applicative)instance, NumberCondition::new));

    @Override
    public boolean isAllowed(ConditionManager.ConditionContext conditionContext) {
        Optional<ModuleInstance> moduleInstance = conditionContext.getContext(ConditionManager.MODULE_CONDITION_CONTEXT);
        if (moduleInstance.isPresent()) {
            double result = StatResolver.resolveDouble(this.condition, moduleInstance.get());
            moduleInstance.get().clearCachesSoftOnlyThis();
            if (result > 0.0) {
                return true;
            }
            conditionContext.failReasons.add(this.error);
            return false;
        }
        return false;
    }

    @Override
    public ResourceLocation getID() {
        return Miapi.id("number");
    }
}

