/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.edit_options;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.Miapi;
import smartin.miapi.client.gui.ClickAbleTextWidget;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.ScrollingTextWidget;
import smartin.miapi.client.gui.SimpleButton;
import smartin.miapi.client.gui.crafting.CraftingScreen;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.modules.ModuleDataPropertiesManager;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.edit_options.EditOption;
import smartin.miapi.modules.edit_options.EditOptionIcon;
import smartin.miapi.modules.properties.util.ModuleProperty;
import smartin.miapi.network.Networking;
import smartin.miapi.registries.RegistryInventory;

public class PropertyInjectionDev
implements EditOption {
    @Override
    public ItemStack preview(FriendlyByteBuf buffer, EditOption.EditContext context) {
        String raw = buffer.readUtf();
        if (raw != null) {
            JsonObject moduleJson = (JsonObject)Miapi.gson.fromJson(raw, JsonObject.class);
            HashMap properties = new HashMap();
            if (moduleJson != null) {
                for (Map.Entry stringJsonElementEntry : moduleJson.entrySet()) {
                    ResourceLocation id = Miapi.id((String)stringJsonElementEntry.getKey());
                    ModuleProperty property = RegistryInventory.MODULE_PROPERTY_MIAPI_REGISTRY.get(id);
                    try {
                        assert (property != null);
                        property.load(Miapi.id("property-injection"), (JsonElement)stringJsonElementEntry.getValue(), true);
                        properties.put(property, property.decode((JsonElement)stringJsonElementEntry.getValue()));
                    }
                    catch (Exception e) {
                        Miapi.LOGGER.error("error during property injection", (Throwable)e);
                    }
                }
            }
            try {
                assert (context.getInstance() != null);
                ModuleInstance current = context.getInstance().copy();
                ModuleDataPropertiesManager.setProperties(current, properties);
                ItemStack stack1 = context.getItemstack().copy();
                current.getRoot().writeToItem(stack1);
                current.getRoot().clearCaches();
                return stack1;
            }
            catch (RuntimeException e) {
                Miapi.LOGGER.error("error during property injection", (Throwable)e);
            }
        }
        return context.getItemstack();
    }

    @Override
    public boolean isVisible(EditOption.EditContext context) {
        return MiapiConfig.getServerConfig().other.developmentMode && context.getInstance() != null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public InteractAbleWidget getGui(int x, int y, int width, int height, EditOption.EditContext context) {
        return new EditDevView(x, y, width, height, context.getItemstack(), context.getInstance(), context::craft);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public InteractAbleWidget getIconGui(int x, int y, int width, int height, Consumer<EditOption> select, Supplier<EditOption> getSelected) {
        return new EditOptionIcon(x, y, width, height, select, getSelected, CraftingScreen.BACKGROUND_TEXTURE, 339, 81, 512, 512, this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class EditDevView
    extends InteractAbleWidget {
        public EditDevView(int x, int y, int width, int height, ItemStack stack, ModuleInstance moduleInstance, Consumer<FriendlyByteBuf> craft) {
            super(x, y, width, height, (Component)Component.empty());
            JsonElement context = moduleInstance.moduleData.get(Miapi.id("properties"));
            if (context == null) {
                context = new JsonObject();
            }
            MutableComponent text = Component.literal((String)context.toString()).copy();
            ClickAbleTextWidget textFieldWidget = new ClickAbleTextWidget(Minecraft.getInstance().font, x + 5, y + 10, this.width - 10, 20, (Component)text);
            textFieldWidget.setMaxLength(Integer.MAX_VALUE);
            textFieldWidget.setEditable(true);
            ScrollingTextWidget error = new ScrollingTextWidget(x + 5, y + 40, this.width - 10, (Component)Component.empty(), FastColor.ARGB32.color((int)255, (int)255, (int)0, (int)0));
            this.addChild(error);
            SimpleButton<Objects> craftButton = new SimpleButton<Objects>(this.getX() + this.width - 41, this.getY() + this.height - 11, 40, 10, (Component)Component.literal((String)"Apply"), null, a -> {
                String raw = textFieldWidget.getValue();
                try {
                    boolean success = true;
                    if (raw != null) {
                        JsonObject moduleJson = (JsonObject)Miapi.gson.fromJson(raw, JsonObject.class);
                        HashMap properties = new HashMap();
                        if (moduleJson != null) {
                            for (Map.Entry stringJsonElementEntry : moduleJson.entrySet()) {
                                ResourceLocation id = Miapi.id((String)stringJsonElementEntry.getKey());
                                ModuleProperty property = RegistryInventory.MODULE_PROPERTY_MIAPI_REGISTRY.get(id);
                                try {
                                    assert (property != null);
                                    property.load(Miapi.id("property-injection"), (JsonElement)stringJsonElementEntry.getValue(), true);
                                    properties.put(property, property.decode((JsonElement)stringJsonElementEntry.getValue()));
                                }
                                catch (Exception e) {
                                    error.setText(Component.nullToEmpty((String)e.getMessage()));
                                    error.textColor = FastColor.ARGB32.color((int)255, (int)255, (int)0, (int)0);
                                    e.printStackTrace();
                                    success = false;
                                }
                            }
                        }
                        try {
                            ModuleDataPropertiesManager.setProperties(moduleInstance.copy(), properties);
                        }
                        catch (RuntimeException e) {
                            error.setText(Component.nullToEmpty((String)e.getMessage()));
                            error.textColor = FastColor.ARGB32.color((int)255, (int)255, (int)0, (int)0);
                            e.printStackTrace();
                            success = false;
                        }
                    }
                    if (success) {
                        FriendlyByteBuf buf = Networking.createBuffer();
                        buf.writeUtf(raw);
                        craft.accept(buf);
                        error.setText(Component.nullToEmpty((String)"success"));
                        error.textColor = FastColor.ARGB32.color((int)255, (int)0, (int)255, (int)0);
                    }
                }
                catch (Exception all) {
                    error.setText(Component.nullToEmpty((String)all.getMessage()));
                    error.textColor = FastColor.ARGB32.color((int)255, (int)255, (int)0, (int)0);
                    all.printStackTrace();
                }
            });
            this.addChild((GuiEventListener)textFieldWidget);
            this.addChild(craftButton);
        }
    }
}

