/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.edit_options.material;

import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.events.GuiEventListener;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.ScrollingTextWidget;
import smartin.miapi.client.gui.SimpleButton;
import smartin.miapi.client.gui.crafting.crafter.replace.hover.HoverMaterialList;
import smartin.miapi.material.base.Material;

public class MaterialGroupWidget
extends InteractAbleWidget {
    private final Set<Material> materials;
    private final SimpleButton<Void> headerButton;
    private boolean isOpen = false;
    private final Consumer<Material> setMaterial;

    public MaterialGroupWidget(int x, int y, int width, String groupName, Set<Material> materials, Consumer<Material> setMaterial) {
        super(x, y, width, 14, HoverMaterialList.getTranslation(groupName));
        this.materials = materials;
        this.setMaterial = setMaterial;
        this.headerButton = new SimpleButton(x, y, width, 14, HoverMaterialList.getTranslation(groupName), this::toggleOpen);
        this.headerButton.textWidget.setOrientation(ScrollingTextWidget.Orientation.LEFT);
        this.addChild(this.headerButton);
        this.height = 14;
    }

    private void toggleOpen() {
        if (this.isOpen) {
            this.children().removeIf(w -> w != this.headerButton);
            this.height = 14;
        } else {
            int yOffset = this.getY() + 14;
            for (Material m : this.materials) {
                SimpleButton matButton = new SimpleButton(this.getX() + 4, yOffset, this.width - 4, 14, m.getTranslation(), () -> this.setMaterial.accept(m));
                this.addChild(matButton);
                yOffset += 14;
            }
            this.height = yOffset - this.getY();
        }
        this.isOpen = !this.isOpen;
    }

    public void setY(int y) {
        super.setY(y);
        this.headerButton.setY(y);
        if (this.isOpen) {
            int yOffset = y + 14;
            for (GuiEventListener w : this.children()) {
                if (w == this.headerButton) continue;
                if (w instanceof InteractAbleWidget) {
                    InteractAbleWidget i = (InteractAbleWidget)w;
                    i.setY(yOffset);
                }
                yOffset += 14;
            }
            this.height = yOffset - y;
        }
    }
}

