/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.edit_options.skins.gui;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import smartin.miapi.Miapi;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.ScrollingTextWidget;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.modules.edit_options.skins.Skin;
import smartin.miapi.modules.edit_options.skins.SkinOptions;
import smartin.miapi.modules.edit_options.skins.SkinTab;
import smartin.miapi.modules.edit_options.skins.gui.SkinButton;
import smartin.miapi.modules.edit_options.skins.gui.SkinGui;

class SkinTabGui
extends InteractAbleWidget
implements SkinGui.SortAble {
    ResourceLocation arrowTexture = Miapi.id("textures/gui/skin/arrow.png");
    boolean isOpen = true;
    List<SkinGui.SortAble> fullList = new ArrayList<SkinGui.SortAble>();
    List<SkinGui.SortAble> currentList;
    ScrollingTextWidget textWidget;
    String sortAble;
    int spacing = 10;
    int realHeight = 14;
    public SkinTabGui parent;
    static final int SIZE_Y = 14;
    final boolean isRoot;
    final SkinTab tabInfo;

    public SkinTabGui(SkinGui skinGui, int x, int y, int width, String currentTab, Map<String, Skin> mapsToDo) {
        super(x, y, width, 14, (Component)Component.empty());
        this.tabInfo = SkinOptions.getTag(currentTab);
        this.height = this.realHeight;
        this.isRoot = currentTab.isBlank();
        if (this.isRoot) {
            this.height = 0;
            this.realHeight = 0;
            this.spacing = 0;
            SkinButton child = new SkinButton(skinGui, x + this.spacing, y, width - this.spacing, "", new Skin());
            this.fullList.add(child);
        }
        String[] parts = currentTab.split("/");
        int partLength = parts.length;
        if (this.isRoot) {
            partLength = 0;
        }
        Component skinName = StatResolver.translateAndResolve("miapi.skin.name." + parts[parts.length - 1], skinGui.instance);
        this.sortAble = skinName.getString();
        this.textWidget = new ScrollingTextWidget(x + 12, y + 1, width - 13, skinName, FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255));
        HashMap<String, Map> toDoMap = new HashMap<String, Map>();
        for (Map.Entry<String, Skin> entry : mapsToDo.entrySet()) {
            String skinPath = entry.getKey();
            String[] pathParts = skinPath.split("/");
            if (!skinPath.startsWith(currentTab + "/") && !this.isRoot) continue;
            if (partLength + 1 == pathParts.length) {
                this.fullList.add(new SkinButton(skinGui, x + this.spacing, y, width - this.spacing, skinPath, entry.getValue()));
                continue;
            }
            String nextPart = pathParts[partLength];
            Object nextTab = currentTab + "/" + nextPart;
            if (this.isRoot) {
                nextTab = nextPart;
            }
            Map subMap = toDoMap.computeIfAbsent((String)nextTab, k -> new HashMap());
            subMap.put(nextTab, entry.getValue());
        }
        toDoMap.forEach((tab, map) -> {
            SkinTabGui child = new SkinTabGui(skinGui, x + this.spacing, y, width - this.spacing, (String)tab, mapsToDo);
            child.parent = this;
            this.fullList.add(child);
        });
        this.currentList = new ArrayList<SkinGui.SortAble>(this.fullList);
        this.setChildren(true);
        if (!this.isRoot) {
            this.toggleOpen();
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (mouseY < (double)(this.getY() + this.realHeight)) {
            this.toggleOpen();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void toggleOpen() {
        if (this.isOpen) {
            this.currentList.clear();
            this.height = this.realHeight;
            this.setChildren(false);
        } else {
            this.currentList = new ArrayList<SkinGui.SortAble>(this.fullList);
            this.setChildren(false);
        }
        this.isOpen = !this.isOpen;
    }

    private boolean isMouseOverReal(double mouseX, double mouseY) {
        return mouseY > (double)this.getY() && mouseY < (double)(this.getY() + this.realHeight) && mouseX > (double)this.getX() && mouseX < (double)(this.getX() + this.width);
    }

    public void setY(int y) {
        super.setY(y);
        this.setChildren(true);
    }

    @Override
    public void renderWidget(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        if (!this.isRoot) {
            int offset = this.isOpen ? 10 : 0;
            int hover = this.isOpen ? this.tabInfo.header.ySize() * 2 : 0;
            hover = this.isMouseOverReal(mouseX, mouseY) ? this.tabInfo.header.ySize() : hover;
            SkinTabGui.drawTextureWithEdge(drawContext, this.arrowTexture, this.getX(), this.getY() + 2, offset, 0, 10, 10, 10, 10, 20, 10, 3);
            SkinTabGui.drawTextureWithEdgeAndScale(drawContext, this.tabInfo.header.texture(), this.getX(), this.getY(), 0, hover, this.tabInfo.header.xSize(), this.tabInfo.header.ySize(), this.width, this.realHeight, this.tabInfo.header.xSize(), this.tabInfo.header.ySize() * 3, this.tabInfo.header.borderSize(), this.tabInfo.header.scale());
            if (this.isOpen) {
                if (this.tabInfo.background.keepScale()) {
                    drawContext.blit(this.tabInfo.background.texture(), this.getX(), this.getY() + this.realHeight, (float)this.width, (float)(this.height - this.realHeight), 0, 0, this.tabInfo.background.xSize(), this.tabInfo.background.ySize());
                } else {
                    SkinTabGui.drawTextureWithEdgeAndScale(drawContext, this.tabInfo.background.texture(), this.getX(), this.getY() + this.realHeight, 0, 0, this.tabInfo.background.xSize(), this.tabInfo.background.ySize(), this.width, this.height - this.realHeight, this.tabInfo.background.xSize(), this.tabInfo.background.ySize(), this.tabInfo.background.borderSize(), this.tabInfo.background.scale());
                }
            }
            this.textWidget.setY(this.getY() + 2);
            this.textWidget.render(drawContext, mouseX, mouseY, delta);
        }
        super.renderWidget(drawContext, mouseX, mouseY, delta);
    }

    private void setChildren(boolean updateChildren) {
        if (this.parent == null) {
            updateChildren = true;
        }
        this.children().clear();
        int yHeight = this.getY() + this.realHeight;
        for (SkinGui.SortAble sortableElement : this.currentList) {
            if (!(sortableElement instanceof InteractAbleWidget)) continue;
            InteractAbleWidget widget = (InteractAbleWidget)((Object)sortableElement);
            if (!sortableElement.isActive()) continue;
            widget.setY(yHeight);
            yHeight += widget.getHeight();
            this.addChild(widget);
            if (!(widget instanceof SkinTabGui)) continue;
            SkinTabGui tab = (SkinTabGui)widget;
            if (!updateChildren) continue;
            tab.setChildren(true);
        }
        this.height = yHeight - this.getY();
        if (!updateChildren) {
            this.parent.setChildren(false);
        }
    }

    @Override
    public void filter(String search) {
        for (SkinGui.SortAble element : this.fullList) {
            element.filter(search);
        }
        this.setChildren(true);
    }

    @Override
    public String sortAndGetTop() {
        this.fullList.sort(Comparator.comparing(SkinGui.SortAble::sortAndGetTop));
        this.currentList = new ArrayList<SkinGui.SortAble>(this.fullList);
        this.setChildren(true);
        return "." + this.fullList.get(0).sortAndGetTop();
    }

    @Override
    public boolean isActive() {
        boolean isEnabled = false;
        for (SkinGui.SortAble element : this.fullList) {
            if (!element.isActive()) continue;
            isEnabled = true;
        }
        return isEnabled;
    }
}

