/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import dev.architectury.event.EventResult;
import dev.architectury.platform.Platform;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import smartin.miapi.Miapi;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.modules.properties.LoreProperty;
import smartin.miapi.modules.properties.util.ComplexBooleanProperty;

public class HandheldItemProperty
extends ComplexBooleanProperty {
    public static ResourceLocation attackspeedID = Miapi.id("handheld_bonus_attackspeed");
    public static final ResourceLocation KEY = Miapi.id("handheld_item");

    public HandheldItemProperty() {
        super(KEY, false);
        MiapiEvents.PLAYER_EQUIP_EVENT.register((player, changes) -> {
            if (player instanceof ServerPlayer) {
                boolean hasAttribute;
                ServerPlayer serverPlayerEntity = (ServerPlayer)player;
                ItemStack mainHandItem = changes.getOrDefault(EquipmentSlot.MAINHAND, player.getItemBySlot(EquipmentSlot.MAINHAND));
                ItemStack offHandItem = changes.getOrDefault(EquipmentSlot.OFFHAND, player.getItemBySlot(EquipmentSlot.OFFHAND));
                boolean bl = hasAttribute = serverPlayerEntity.getAttributes().getInstance(Attributes.ATTACK_SPEED).getModifier(attackspeedID) != null;
                if (this.hasTwoHandhelds(mainHandItem, offHandItem)) {
                    if (!hasAttribute) {
                        serverPlayerEntity.getAttributes().getInstance(Attributes.ATTACK_SPEED).addTransientModifier(new AttributeModifier(attackspeedID, 1.5, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
                    }
                } else if (hasAttribute) {
                    serverPlayerEntity.getAttributes().getInstance(Attributes.ATTACK_SPEED).removeModifier(attackspeedID);
                }
            }
            return EventResult.pass();
        });
        MiapiEvents.LIVING_HURT_AFTER.register(event -> {
            Player serverPlayerEntity;
            Entity patt0$temp;
            if (event.damageSource != null && (patt0$temp = event.damageSource.getEntity()) instanceof Player && this.hasTwoHandhelds(serverPlayerEntity = (Player)patt0$temp) && !Platform.isModLoaded((String)"bettercombat")) {
                this.swapHands(serverPlayerEntity);
            }
            return EventResult.pass();
        });
        LoreProperty.loreSuppliers.add((stack, tooltip, context, flag) -> {
            if (this.hasValue(stack)) {
                tooltip.add(Component.translatable((String)"miapi.handheld.tooltip"));
            }
        });
    }

    public void swapHands(Player playerEntity) {
        ItemStack itemStack = playerEntity.getItemBySlot(EquipmentSlot.OFFHAND);
        playerEntity.setItemSlot(EquipmentSlot.OFFHAND, playerEntity.getItemBySlot(EquipmentSlot.MAINHAND));
        playerEntity.setItemSlot(EquipmentSlot.MAINHAND, itemStack);
    }

    public boolean hasTwoHandhelds(Player player) {
        return this.hasTwoHandhelds(player.getItemBySlot(EquipmentSlot.MAINHAND), player.getItemBySlot(EquipmentSlot.OFFHAND));
    }

    public boolean hasTwoHandhelds(ItemStack mainHand, ItemStack offHand) {
        return this.hasValue(mainHand) && this.hasValue(offHand);
    }
}

