/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import smartin.miapi.Miapi;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.ComponentApplyProperty;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

public class RarityProperty
extends CodecProperty<Rarity>
implements ComponentApplyProperty {
    public static final ResourceLocation KEY = Miapi.id("rarity");
    public static RarityProperty property;

    public RarityProperty() {
        super(Rarity.CODEC);
        property = this;
    }

    public static Rarity getRarity(ItemStack itemStack) {
        return RarityProperty.applyEnchant(itemStack, property.getData(itemStack).orElse(Rarity.COMMON));
    }

    private static Rarity applyEnchant(ItemStack itemStack, Rarity old) {
        if (!itemStack.isEnchanted()) {
            return old;
        }
        return switch (old) {
            case Rarity.COMMON, Rarity.UNCOMMON -> Rarity.RARE;
            case Rarity.RARE -> Rarity.EPIC;
            default -> old;
        };
    }

    @Override
    public Rarity merge(Rarity left, Rarity right, MergeType mergeType) {
        return MergeAble.decideLeftRight(left, right, mergeType);
    }

    @Override
    public void updateComponent(ItemStack itemStack, RegistryAccess registryAccess) {
        Rarity rarity = RarityProperty.getRarity(itemStack);
        itemStack.set(DataComponents.RARITY, (Object)rarity);
    }
}

