/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.attributes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.event.EventResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.attributes.AttributeProperty;
import smartin.miapi.modules.properties.attributes.AttributeUtil;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;
import smartin.miapi.modules.properties.util.MergeType;

public class AttributeSplitProperty
extends CodecProperty<Map<Context, List<SplitContext>>> {
    public static final ResourceLocation KEY = Miapi.id("attribute_split");
    public static final Codec<Map<ResourceLocation, Map<EquipmentSlotGroup, List<ActualInner>>>> ACUTAL_CODEC = Codec.unboundedMap((Codec)ResourceLocation.CODEC, (Codec)Codec.unboundedMap((Codec)EquipmentSlotGroup.CODEC, (Codec)ActualInner.CODEC.listOf()));
    public static final Codec<Map<Context, List<SplitContext>>> CODEC = ACUTAL_CODEC.xmap(map -> {
        HashMap finishedMap = new HashMap();
        map.forEach((id, innerMap) -> innerMap.forEach((group, dataList) -> dataList.forEach(data -> {
            Context context = new Context((ResourceLocation)id, (EquipmentSlotGroup)group);
            finishedMap.computeIfAbsent(context, c -> new ArrayList()).add(new SplitContext(data.targetAttribute(), data.percent, data.target, null));
        })));
        return finishedMap;
    }, inner -> {
        HashMap finishedMap = new HashMap();
        inner.forEach((context, split) -> split.forEach(splitContext -> finishedMap.computeIfAbsent(context.entityAttribute(), c -> new HashMap()).computeIfAbsent(context.target(), e -> new ArrayList()).add(new ActualInner(splitContext.entityAttribute(), splitContext.percent(), splitContext.target()))));
        return finishedMap;
    });

    @Override
    public Map<Context, List<SplitContext>> initialize(Map<Context, List<SplitContext>> property, ModuleInstance context) {
        HashMap<Context, List<SplitContext>> map = new HashMap<Context, List<SplitContext>>();
        property.forEach((attributeContext, list) -> {
            List<SplitContext> newList = list.stream().map(splitContext -> new SplitContext(splitContext.entityAttribute(), splitContext.percent().initialize(context), splitContext.target, context)).toList();
            map.put((Context)attributeContext, newList);
        });
        return map;
    }

    public AttributeSplitProperty() {
        super(CODEC);
        AttributeUtil.ITEM_ATTRIBUTE_ADJUST.register((attributeContext, itemStack) -> {
            HashMap<ResourceLocation, Map<AttributeModifier.Operation, Map<Either<EquipmentSlotGroup, Boolean>, DoubleOperationResolvable>>> map = new HashMap<ResourceLocation, Map<AttributeModifier.Operation, Map<Either<EquipmentSlotGroup, Boolean>, DoubleOperationResolvable>>>(attributeContext.map);
            Map replaceMap = this.getData(itemStack).orElse(new HashMap());
            for (Map.Entry entry : replaceMap.entrySet()) {
                Map operationMap;
                Map addValueMap;
                EquipmentSlotGroup equipmentSlot = ((Context)entry.getKey()).target();
                List ratios = (List)entry.getValue();
                ResourceLocation attributeKey = AttributeProperty.replaceMap.containsKey(((Context)entry.getKey()).entityAttribute().toString()) ? BuiltInRegistries.ATTRIBUTE.getKey((Object)AttributeProperty.replaceMap.get(((Context)entry.getKey()).entityAttribute().toString()).get()) : ((Context)entry.getKey()).entityAttribute();
                if (!map.containsKey(attributeKey) || (addValueMap = (Map)(operationMap = (Map)map.get(attributeKey)).get(AttributeModifier.Operation.ADD_VALUE)) == null) continue;
                double totalValue = addValueMap.entrySet().stream().filter(entrySet -> ((Either)entrySet.getKey()).left().isPresent() && ((EquipmentSlotGroup)((Either)entrySet.getKey()).left().get()).equals((Object)equipmentSlot)).mapToDouble(entrySet -> ((DoubleOperationResolvable)entrySet.getValue()).getValue()).sum();
                for (SplitContext splitContext : ratios) {
                    EquipmentSlotGroup targetGroup = splitContext.target() == null ? equipmentSlot : splitContext.target();
                    Either targetKey = Either.left((Object)targetGroup);
                    DoubleOperationResolvable resolveAble = (DoubleOperationResolvable)addValueMap.get(targetKey);
                    if (resolveAble != null) {
                        DoubleOperationResolvable.IndividualOperation operation = new DoubleOperationResolvable.IndividualOperation(totalValue * splitContext.percent().getValue() / 100.0, DoubleOperationResolvable.IndividualOperation.Operation.ADD_VALUE);
                        operation.instance = splitContext.moduleInstance;
                        ArrayList<DoubleOperationResolvable.IndividualOperation> operations = new ArrayList<DoubleOperationResolvable.IndividualOperation>(resolveAble.operations);
                        operations.add(operation);
                        resolveAble.operations = operations;
                        resolveAble.clearCache();
                        resolveAble.getValue();
                        continue;
                    }
                    resolveAble = new DoubleOperationResolvable(List.of(new DoubleOperationResolvable.IndividualOperation(totalValue * splitContext.percent().getValue() / 100.0, DoubleOperationResolvable.IndividualOperation.Operation.ADD_VALUE)));
                    resolveAble = resolveAble.initialize(splitContext.moduleInstance);
                    addValueMap.put(targetKey, resolveAble);
                }
            }
            return EventResult.pass();
        });
    }

    @Override
    public Map<Context, List<SplitContext>> merge(Map<Context, List<SplitContext>> left, Map<Context, List<SplitContext>> right, MergeType mergeType) {
        HashMap<Context, List<SplitContext>> merged = new HashMap<Context, List<SplitContext>>(left);
        right.forEach((context, splitContexts) -> {
            if (merged.containsKey(context)) {
                ArrayList contexts = new ArrayList((Collection)merged.get(context));
                contexts.addAll(splitContexts);
                merged.put((Context)context, contexts);
            } else {
                merged.put((Context)context, (List<SplitContext>)splitContexts);
            }
        });
        return merged;
    }

    public record Context(ResourceLocation entityAttribute, EquipmentSlotGroup target) {
    }

    public record SplitContext(ResourceLocation entityAttribute, DoubleOperationResolvable percent, @Nullable EquipmentSlotGroup target, @Nullable ModuleInstance moduleInstance) {
    }

    public record ActualInner(ResourceLocation targetAttribute, DoubleOperationResolvable percent, EquipmentSlotGroup target) {
        public static final Codec<ActualInner> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("attribute").forGetter(ActualInner::targetAttribute), (App)DoubleOperationResolvable.CODEC.fieldOf("percentage").forGetter(ActualInner::percent), (App)EquipmentSlotGroup.CODEC.fieldOf("target").forGetter(ActualInner::target)).apply((Applicative)instance, ActualInner::new));
    }
}

