/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.attributes;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Either;
import com.redpxnda.nucleus.event.PrioritizedEvent;
import dev.architectury.event.EventResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import smartin.miapi.Miapi;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;

public class AttributeUtil {
    public static final PrioritizedEvent<AttributeAdjustEvent> MODULE_ATTRIBUTE_ADJUST = PrioritizedEvent.createEventResult((Object[])new AttributeAdjustEvent[0]);
    public static final PrioritizedEvent<ItemAttributeAdjustEvent> ITEM_ATTRIBUTE_ADJUST = PrioritizedEvent.createEventResult((Object[])new ItemAttributeAdjustEvent[0]);
    public static final PrioritizedEvent<ItemVanillaAttributeAdjustEvent> VANILLA_ITEM_ATTRIBUTE_ADJUST = PrioritizedEvent.createEventResult((Object[])new ItemVanillaAttributeAdjustEvent[0]);

    public static Multimap<Attribute, AttributeModifier> getAttribute(ItemStack itemStack, EquipmentSlot equipmentSlot) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        ItemAttributeModifiers attributeModifiers = (ItemAttributeModifiers)itemStack.getComponents().get(DataComponents.ATTRIBUTE_MODIFIERS);
        if (attributeModifiers != null) {
            attributeModifiers.forEach(equipmentSlot, (arg_0, arg_1) -> AttributeUtil.lambda$getAttribute$0((Multimap)multimap, arg_0, arg_1));
        }
        return multimap;
    }

    public static Multimap<Attribute, AttributeModifier> getAttribute(ItemStack itemStack, EquipmentSlotGroup equipmentSlot) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        ItemAttributeModifiers attributeModifiers = (ItemAttributeModifiers)itemStack.getComponents().get(DataComponents.ATTRIBUTE_MODIFIERS);
        if (attributeModifiers != null) {
            attributeModifiers.forEach(equipmentSlot, (arg_0, arg_1) -> AttributeUtil.lambda$getAttribute$1((Multimap)multimap, arg_0, arg_1));
        }
        return multimap;
    }

    public static double getActualValue(ItemStack stack, EquipmentSlot slot, Attribute entityAttribute, double fallback) {
        if (entityAttribute == null) {
            return fallback;
        }
        ArrayList<AttributeModifier> modifiers = new ArrayList<AttributeModifier>();
        ItemAttributeModifiers attributeModifiers = (ItemAttributeModifiers)stack.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
        attributeModifiers.forEach(slot, (attribute, modifier) -> {
            if (entityAttribute.equals(attribute.value())) {
                modifiers.add((AttributeModifier)modifier);
            }
        });
        return AttributeUtil.getActualValue(modifiers, fallback);
    }

    public static double getActualValue(Multimap<Attribute, AttributeModifier> map, Attribute entityAttribute, double fallback) {
        Collection attributes = map.get((Object)entityAttribute);
        return AttributeUtil.getActualValue(attributes, fallback);
    }

    public static double getActualValue(Collection<AttributeModifier> attributes, double fallback) {
        ArrayList addition = new ArrayList();
        ArrayList multiplyBase = new ArrayList();
        ArrayList multiplyTotal = new ArrayList();
        attributes.forEach(attribute -> {
            switch (attribute.operation()) {
                case ADD_VALUE: {
                    addition.add(attribute.amount());
                    break;
                }
                case ADD_MULTIPLIED_BASE: {
                    multiplyBase.add(attribute.amount());
                    break;
                }
                case ADD_MULTIPLIED_TOTAL: {
                    multiplyTotal.add(attribute.amount());
                }
            }
        });
        double value = fallback;
        for (Double currentValue : addition) {
            value += currentValue.doubleValue();
        }
        double multiplier = 1.0;
        for (Double currentValue : multiplyBase) {
            multiplier += currentValue.doubleValue();
        }
        value *= multiplier;
        for (Double currentValue : multiplyTotal) {
            value = (1.0 + currentValue) * value;
        }
        if (Double.isNaN(value)) {
            return fallback;
        }
        return value;
    }

    public static double getActualValue(ItemStack stack, EquipmentSlot slot, Attribute entityAttribute) {
        return AttributeUtil.getActualValue(stack, slot, entityAttribute, entityAttribute.getDefaultValue());
    }

    public static ResourceLocation getIDForSlot(EquipmentSlotGroup equipmentSlot, Attribute attribute, AttributeModifier.Operation operation) {
        if (equipmentSlot.equals((Object)EquipmentSlotGroup.MAINHAND) && attribute.equals(Attributes.ATTACK_DAMAGE.value()) && operation.equals((Object)AttributeModifier.Operation.ADD_VALUE)) {
            return SwordItem.BASE_ATTACK_DAMAGE_ID;
        }
        if (equipmentSlot.equals((Object)EquipmentSlotGroup.MAINHAND) && attribute.equals(Attributes.ATTACK_SPEED.value()) && operation.equals((Object)AttributeModifier.Operation.ADD_VALUE)) {
            return SwordItem.BASE_ATTACK_SPEED_ID;
        }
        return AttributeUtil.getIDForSlot(equipmentSlot, attribute, operation, "");
    }

    public static ResourceLocation getIDForSlot(EquipmentSlotGroup equipmentSlot, Attribute attribute, AttributeModifier.Operation operation, String context) {
        String slotidString = equipmentSlot.getSerializedName() + "-" + attribute.getDescriptionId() + "-" + equipmentSlot.name() + "-" + equipmentSlot.ordinal() + "-" + operation.toString() + context;
        return AttributeUtil.getIDForSlot(slotidString);
    }

    public static ResourceLocation getIDForSlot(String slotidString) {
        return Miapi.id(slotidString.toLowerCase(Locale.ROOT));
    }

    private static /* synthetic */ void lambda$getAttribute$1(Multimap multimap, Holder attributeHolder, AttributeModifier attributeModifier) {
        multimap.put((Object)((Attribute)attributeHolder.value()), (Object)attributeModifier);
    }

    private static /* synthetic */ void lambda$getAttribute$0(Multimap multimap, Holder attributeHolder, AttributeModifier attributeModifier) {
        multimap.put((Object)((Attribute)attributeHolder.value()), (Object)attributeModifier);
    }

    public static interface AttributeAdjustEvent {
        public EventResult adjust(AttributeContext var1, ModuleInstance var2);
    }

    public static interface ItemAttributeAdjustEvent {
        public EventResult adjust(AttributeContext var1, ItemStack var2);
    }

    public static interface ItemVanillaAttributeAdjustEvent {
        public EventResult adjust(ItemVanillaAttributeContext var1, ItemStack var2);
    }

    public static class ItemVanillaAttributeContext {
        List<ItemAttributeModifiers.Entry> list;
    }

    public static class AttributeContext {
        Map<ResourceLocation, Map<AttributeModifier.Operation, Map<Either<EquipmentSlotGroup, Boolean>, DoubleOperationResolvable>>> map;
    }
}

