/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.enchanment;

import com.mojang.serialization.Codec;
import dev.architectury.event.EventResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.crafting.statdisplay.DoubleResolvableStatDisplay;
import smartin.miapi.client.gui.crafting.statdisplay.StatListWidget;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.enchanment.FakeEnchantmentManager;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;
import smartin.miapi.modules.properties.util.EitherModuleProperty;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

public class FakeEitherEnchantmentProperty
extends EitherModuleProperty<Map<ResourceLocation, DoubleOperationResolvable>, Map<Holder.Reference<Enchantment>, DoubleOperationResolvable>> {
    public static final ResourceLocation KEY = Miapi.id("fake_enchants");
    public static Codec<Map<ResourceLocation, DoubleOperationResolvable>> CODEC = Codec.unboundedMap((Codec)ResourceLocation.CODEC, DoubleOperationResolvable.CODEC);

    public FakeEitherEnchantmentProperty() {
        super(CODEC);
        FakeEnchantmentManager.transformerList.add((enchantmentHolder, itemStack, oldLevel) -> {
            for (Map.Entry<Holder.Reference<Enchantment>, DoubleOperationResolvable> location : this.getEnchants(itemStack).entrySet()) {
                if (!enchantmentHolder.is((Holder)location.getKey())) continue;
                DoubleOperationResolvable resolvable = location.getValue();
                oldLevel = (int)resolvable.evaluate(oldLevel, oldLevel);
            }
            return oldLevel;
        });
        FakeEnchantmentManager.ADD_ENCHANTMENT.register(enchantmentMap -> {
            for (Map.Entry<Holder.Reference<Enchantment>, DoubleOperationResolvable> location : this.getEnchants(enchantmentMap.referenceStack).entrySet()) {
                if (enchantmentMap.enchantments.contains(location.getKey())) continue;
                enchantmentMap.enchantments.add((Holder<Enchantment>)((Holder)location.getKey()));
            }
            return EventResult.pass();
        });
        if (Environment.isClient()) {
            this.setupClient();
        }
    }

    @Override
    protected Map<Holder.Reference<Enchantment>, DoubleOperationResolvable> initializeDecode(Map<ResourceLocation, DoubleOperationResolvable> property, ModuleInstance context) {
        HashMap<Holder.Reference<Enchantment>, DoubleOperationResolvable> initialized = new HashMap<Holder.Reference<Enchantment>, DoubleOperationResolvable>();
        property.forEach((id, resolvable) -> {
            if (Miapi.registryAccess != null) {
                FakeEitherEnchantmentProperty.getWithRegistry(Miapi.registryAccess, id, resolvable, initialized, context);
            }
            if (Miapi.clientRegistryAccess != null) {
                FakeEitherEnchantmentProperty.getWithRegistry(Miapi.clientRegistryAccess, id, resolvable, initialized, context);
            }
        });
        return initialized;
    }

    private static void getWithRegistry(RegistryAccess clientRegistryAccess, ResourceLocation id, DoubleOperationResolvable resolvable, Map<Holder.Reference<Enchantment>, DoubleOperationResolvable> initialized, ModuleInstance context) {
        clientRegistryAccess.lookup(Registries.ENCHANTMENT).ifPresentOrElse(enchantmentRegistryInfo -> enchantmentRegistryInfo.get(ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)id)).ifPresentOrElse(holder -> {
            resolvable.setFunctionTransformer(s -> ((String)s.getFirst()).replace("[old_level]", "0"));
            initialized.put((Holder.Reference<Enchantment>)holder, resolvable.initialize(context));
        }, () -> Miapi.LOGGER.warn("Could not find enchantment " + String.valueOf(id) + " skiping")), () -> Miapi.LOGGER.warn("Enchantment Registries not Found - could not decode enchantments"));
    }

    @Override
    protected Map<Holder.Reference<Enchantment>, DoubleOperationResolvable> mergeInterpreted(Map<Holder.Reference<Enchantment>, DoubleOperationResolvable> left, Map<Holder.Reference<Enchantment>, DoubleOperationResolvable> right, MergeType mergeType) {
        return MergeAble.mergeMap(left, right, mergeType, (e, l, r) -> DoubleOperationResolvable.merge(l, r, mergeType));
    }

    @Override
    protected Map<ResourceLocation, DoubleOperationResolvable> mergeRaw(Map<ResourceLocation, DoubleOperationResolvable> left, Map<ResourceLocation, DoubleOperationResolvable> right, MergeType mergeType) {
        return MergeAble.mergeMap(left, right, mergeType, (e, l, r) -> DoubleOperationResolvable.merge(l, r, mergeType));
    }

    @Override
    protected Map<ResourceLocation, DoubleOperationResolvable> deInitialize(Map<Holder.Reference<Enchantment>, DoubleOperationResolvable> property) {
        HashMap<ResourceLocation, DoubleOperationResolvable> map = new HashMap<ResourceLocation, DoubleOperationResolvable>();
        property.forEach((id, resolvable) -> map.put(id.key().location(), (DoubleOperationResolvable)resolvable));
        return map;
    }

    public Map<Holder.Reference<Enchantment>, DoubleOperationResolvable> getEnchants(ItemStack itemStack) {
        return this.getData(itemStack).flatMap(c -> c.right()).orElse(Map.of());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setupClient() {
        StatListWidget.addStatDisplaySupplier(new StatListWidget.StatWidgetSupplier(){

            @Override
            public <T extends InteractAbleWidget> List<T> currentList(ItemStack original, ItemStack compareTo) {
                ArrayList displays = new ArrayList();
                HashMap<Object, DoubleOperationResolvable> enchantments = new HashMap<Object, DoubleOperationResolvable>();
                enchantments.putAll(FakeEitherEnchantmentProperty.this.getEnchants(original));
                enchantments.putAll(FakeEitherEnchantmentProperty.this.getEnchants(compareTo));
                enchantments.forEach((enchantment, data) -> {
                    MutableComponent desc = Component.translatableWithFallback((String)("enchantment." + enchantment.key().location().getNamespace() + "." + enchantment.key().location().getPath() + ".desc"), (String)"");
                    displays.add(DoubleResolvableStatDisplay.builder(s -> Optional.ofNullable(FakeEitherEnchantmentProperty.this.getEnchants((ItemStack)s).get(enchantment))).setHoverDescription((Component)Component.translatable((String)"miapi.fake_enchant.desc", (Object[])new Object[]{((Enchantment)enchantment.value()).description(), desc})).setName(((Enchantment)enchantment.value()).description()).setMax(((Enchantment)enchantment.value()).getMaxLevel()).setFormat("#").setInverse(enchantment.is(EnchantmentTags.CURSE)).setMin(0.0).build());
                });
                return displays;
            }
        });
    }
}

