/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.enchanment;

import com.mojang.serialization.Codec;
import dev.architectury.event.EventResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.crafting.statdisplay.JsonStatDisplay;
import smartin.miapi.client.gui.crafting.statdisplay.SingleStatDisplayDouble;
import smartin.miapi.client.gui.crafting.statdisplay.StatListWidget;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.enchanment.CraftingEnchantProperty;
import smartin.miapi.modules.properties.enchanment.FakeEnchantmentManager;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

public class FakeEnchantmentProperty
extends CodecProperty<Map<ResourceLocation, DoubleOperationResolvable>> {
    public static FakeEnchantmentProperty property;
    public static final ResourceLocation KEY;
    public static Codec<Map<ResourceLocation, DoubleOperationResolvable>> CODEC;

    public FakeEnchantmentProperty() {
        super(CODEC);
        property = this;
        FakeEnchantmentManager.transformerList.add((enchantmentHolder, itemStack, oldLevel) -> {
            for (Map.Entry location : ((Map)this.getData(itemStack).orElse(new HashMap())).entrySet()) {
                if (!enchantmentHolder.is((ResourceLocation)location.getKey())) continue;
                DoubleOperationResolvable resolvable = (DoubleOperationResolvable)location.getValue();
                resolvable.setFunctionTransformer(s -> ((String)s.getFirst()).replace("[old_level]", String.valueOf(oldLevel)));
                return (int)resolvable.evaluate(0.0, oldLevel);
            }
            return oldLevel;
        });
        FakeEnchantmentManager.ADD_ENCHANTMENT.register(enchantmentMap -> {
            for (Map.Entry location : ((Map)this.getData(enchantmentMap.referenceStack).orElse(new HashMap())).entrySet()) {
                CraftingEnchantProperty.tryAndLookUp((ResourceLocation)location.getKey(), enchantmentMap.referenceStack).ifPresent(enchantment -> {
                    if (!enchantmentMap.enchantments.contains(enchantment)) {
                        enchantmentMap.enchantments.add((Holder<Enchantment>)enchantment);
                    }
                });
            }
            return EventResult.pass();
        });
        if (Environment.isClient()) {
            this.setupClient();
        }
    }

    @Override
    public Map<Holder<Enchantment>, DoubleOperationResolvable> initialize(Map<Holder<Enchantment>, DoubleOperationResolvable> property, ModuleInstance context) {
        LinkedHashMap<Holder<Enchantment>, DoubleOperationResolvable> init = new LinkedHashMap<Holder<Enchantment>, DoubleOperationResolvable>();
        property.forEach((key, value) -> {
            value.setFunctionTransformer(stringModuleInstancePair -> ((String)stringModuleInstancePair.getFirst()).replace("[old_level]", "0"));
            init.put((Holder<Enchantment>)key, value.initialize(context));
        });
        return init;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setupClient() {
        StatListWidget.addStatDisplaySupplier(new StatListWidget.StatWidgetSupplier(){

            @Override
            public <T extends InteractAbleWidget> List<T> currentList(ItemStack original, ItemStack compareTo) {
                ArrayList displays = new ArrayList();
                HashSet<Holder<Enchantment>> enchantments = new HashSet<Holder<Enchantment>>();
                enchantments.addAll(CraftingEnchantProperty.tryConvert(FakeEnchantmentProperty.this.getData(original).orElse(new HashMap()), original).keySet());
                enchantments.addAll(CraftingEnchantProperty.tryConvert(FakeEnchantmentProperty.this.getData(compareTo).orElse(new HashMap()), compareTo).keySet());
                enchantments.forEach(enchantment -> {
                    JsonStatDisplay display = new JsonStatDisplay(stack -> ((Enchantment)enchantment.value()).description(), stack -> ((Enchantment)enchantment.value()).description(), new SingleStatDisplayDouble.StatReaderHelper(){
                        final /* synthetic */ Holder val$enchantment;
                        {
                            this.val$enchantment = holder;
                        }

                        @Override
                        public double getValue(ItemStack itemStack) {
                            return EnchantmentHelper.getItemEnchantmentLevel((Holder)this.val$enchantment, (ItemStack)itemStack);
                        }

                        @Override
                        public boolean hasValue(ItemStack itemStack) {
                            return true;
                        }
                    }, 0.0, ((Enchantment)enchantment.value()).getMaxLevel());
                    if (enchantment.is(EnchantmentTags.CURSE)) {
                        display.inverse = true;
                    }
                    displays.add(display);
                });
                return displays;
            }
        });
    }

    @Override
    public Map<ResourceLocation, DoubleOperationResolvable> merge(Map<ResourceLocation, DoubleOperationResolvable> left, Map<ResourceLocation, DoubleOperationResolvable> right, MergeType mergeType) {
        return MergeAble.mergeMap(left, right, mergeType);
    }

    static {
        KEY = Miapi.id("fake_enchants_old");
        CODEC = Codec.unboundedMap((Codec)ResourceLocation.CODEC, DoubleOperationResolvable.CODEC);
    }
}

