/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.mining.mode;

import com.mojang.serialization.MapCodec;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import dev.architectury.event.events.common.TickEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import smartin.miapi.Miapi;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.mining.mode.MiningMode;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;

public class StaggeredMiningMode
implements MiningMode {
    public static List<Runnable> nextTickTask = new ArrayList<Runnable>();
    public static MapCodec<StaggeredMiningMode> CODEC = AutoCodec.of(StaggeredMiningMode.class);
    public static ResourceLocation ID = Miapi.id("staggered");
    @CodecBehavior.Optional
    public DoubleOperationResolvable speed = new DoubleOperationResolvable(1.0);
    @CodecBehavior.Optional
    @AutoCodec.Name(value="durability_break_chance")
    public DoubleOperationResolvable durabilityBreakChance = new DoubleOperationResolvable(1.0);

    @Override
    public void execute(List<BlockPos> posList, Level world, ServerPlayer player, BlockPos origin, ItemStack itemStack) {
        ArrayList<BlockPos> reducedList = new ArrayList<BlockPos>(posList);
        reducedList.sort(Comparator.comparingDouble(pos -> pos.distSqr((Vec3i)origin)));
        nextTickTask.add(() -> {
            int success = 0;
            do {
                BlockPos pos = (BlockPos)reducedList.remove(0);
                if (itemStack.getMaxDamage() - itemStack.getDamageValue() < 2) {
                    return;
                }
                if (!this.tryBreakBlock(player, pos)) continue;
                ++success;
                if (player.isCreative()) continue;
                this.removeDurability(this.durabilityBreakChance.getValue(), itemStack, world, player);
            } while ((double)success < this.speed.getValue() && !reducedList.isEmpty() && itemStack.getMaxDamage() - itemStack.getDamageValue() > 1);
            if (!reducedList.isEmpty() && itemStack.getMaxDamage() - itemStack.getDamageValue() > 1) {
                this.execute(reducedList, world, player, origin, itemStack);
            }
        });
    }

    @Override
    public ResourceLocation getID() {
        return ID;
    }

    @Override
    public MiningMode initialize(MiningMode property, ModuleInstance context) {
        StaggeredMiningMode mode = new StaggeredMiningMode();
        mode.speed = ((StaggeredMiningMode)property).speed.initialize(context);
        mode.durabilityBreakChance = ((StaggeredMiningMode)property).durabilityBreakChance.initialize(context);
        return mode;
    }

    static {
        TickEvent.SERVER_POST.register(server -> {
            ArrayList<Runnable> currentTicks = new ArrayList<Runnable>(nextTickTask);
            nextTickTask.clear();
            currentTicks.forEach(arg_0 -> ((MinecraftServer)server).execute(arg_0));
        });
    }
}

