/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.mining.shape;

import com.mojang.serialization.MapCodec;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import smartin.miapi.Miapi;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.mining.shape.MiningShape;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;

public class VeinMiningShape
implements MiningShape {
    public static MapCodec<VeinMiningShape> CODEC = AutoCodec.of(VeinMiningShape.class);
    public static ResourceLocation ID = Miapi.id("vein");
    public int size = 5;
    @CodecBehavior.Optional
    public DoubleOperationResolvable max = new DoubleOperationResolvable(15.0);

    @Override
    public List<BlockPos> getMiningBlocks(Level world, BlockPos pos, Direction face) {
        ArrayList<BlockPos> miningBlocks = new ArrayList<BlockPos>();
        if (this.max.getValue() < 1.0) {
            return miningBlocks;
        }
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        ArrayList<BlockPos> visited = new ArrayList<BlockPos>();
        queue.add(pos);
        visited.add(pos);
        BlockState centerState = world.getBlockState(pos);
        while (!queue.isEmpty() && miningBlocks.size() < this.size * this.size * this.size && (double)miningBlocks.size() < this.max.getValue()) {
            BlockPos currentPos = (BlockPos)queue.poll();
            miningBlocks.add(currentPos);
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        if (dx == 0 && dy == 0 && dz == 0) continue;
                        BlockPos neighborPos = currentPos.offset(dx, dy, dz);
                        int dx1 = neighborPos.getX() - pos.getX() + this.size;
                        int dy1 = neighborPos.getY() - pos.getY() + this.size;
                        int dz1 = neighborPos.getZ() - pos.getZ() + this.size;
                        if (Math.abs(dx1 - this.size) > this.size || Math.abs(dy1 - this.size) > this.size || Math.abs(dz1 - this.size) > this.size || visited.contains(neighborPos)) continue;
                        visited.add(neighborPos);
                        BlockState neighborState = world.getBlockState(neighborPos);
                        if (!neighborState.getBlock().equals(centerState.getBlock())) continue;
                        queue.add(neighborPos);
                    }
                }
            }
        }
        return miningBlocks;
    }

    @Override
    public ResourceLocation getID() {
        return ID;
    }

    @Override
    public MiningShape initialize(MiningShape property, ModuleInstance context) {
        VeinMiningShape miningShape = new VeinMiningShape();
        miningShape.max = ((VeinMiningShape)property).max.initialize(context);
        miningShape.size = ((VeinMiningShape)property).size;
        return miningShape;
    }
}

