/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.onHit.entity;

import dev.architectury.event.EventResult;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import smartin.miapi.Miapi;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.modules.properties.onHit.entity.GenericEntityStrengthProperty;

public class EntityArmorStrength
extends GenericEntityStrengthProperty {
    public static final ResourceLocation KEY = Miapi.id("entity_armor");

    public EntityArmorStrength() {
        MiapiEvents.LIVING_HURT.register((Object)new MiapiEvents.LivingHurt(){

            @Override
            public EventResult hurt(MiapiEvents.LivingHurtEvent event) {
                if (event.attacker != null) {
                    double strength = EntityArmorStrength.this.strengthForEntity(event.attacker.getType().arch$holder(), event.defender.getArmorAndBodyArmorSlots());
                    event.amount *= 1.0f - (float)EntityArmorStrength.valueRemap(strength);
                }
                return EventResult.pass();
            }
        });
    }

    @Override
    public Component getFallbackName(EntityType<?> firstType) {
        return Component.translatable((String)"miapi.property.entity.armor.default", (Object[])new Object[]{firstType.getDescription()});
    }

    @Override
    public Component getBaseDescription(double strength) {
        return Component.translatable((String)"miapi.property.entity.armor.description", (Object[])new Object[]{String.format("%.2f", 100.0 * EntityArmorStrength.valueRemap(strength))});
    }

    public static double valueRemap(double x) {
        if (x < 0.0) {
            return -EntityArmorStrength.reductionHyperbolic(-x, 50.0, 3.0);
        }
        return EntityArmorStrength.reductionHyperbolic(x, 50.0, 3.0);
    }

    public static double reductionHyperbolic(double a, double K, double M) {
        double ehp = 1.0 + M * (a / (a + K));
        return 1.0 - 1.0 / ehp;
    }
}

