/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.onHit.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.platform.Platform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Helper;
import smartin.miapi.Miapi;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.crafting.statdisplay.DoubleResolvableStatDisplay;
import smartin.miapi.client.gui.crafting.statdisplay.StatListWidget;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

public abstract class GenericEntityStrengthProperty
extends CodecProperty<Map<ResourceLocation, EntityContext>> {
    protected GenericEntityStrengthProperty() {
        super(Codec.unboundedMap(Miapi.ID_CODEC, EntityContext.CODEC));
        if (Platform.getEnv() == Dist.CLIENT) {
            this.setupToolTip();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setupToolTip() {
        StatListWidget.addStatDisplaySupplier(new StatListWidget.StatWidgetSupplier(){

            @Override
            public <T extends InteractAbleWidget> List<T> currentList(ItemStack original, ItemStack compareTo) {
                ArrayList displays = new ArrayList();
                HashMap map = new HashMap(GenericEntityStrengthProperty.this.getData(original).orElse(Map.of()));
                map.putAll(GenericEntityStrengthProperty.this.getData(compareTo).orElse(Map.of()));
                map.forEach((id, edit) -> {
                    EntityType<?> exampleType = edit.firstType();
                    if (exampleType != null) {
                        displays.add(DoubleResolvableStatDisplay.builder(s -> GenericEntityStrengthProperty.this.getData((ItemStack)s).filter(a -> a.containsKey(id)).map(a -> ((EntityContext)a.get(id)).strength())).setMax(8.0).setName(edit.name().orElse(GenericEntityStrengthProperty.this.getFallbackName(exampleType))).setHoverDescription(stack -> {
                            MutableComponent component = Component.empty();
                            component.append(edit.name().orElse(GenericEntityStrengthProperty.this.getFallbackName(exampleType))).append("\n").append(GenericEntityStrengthProperty.this.getBaseDescription(GenericEntityStrengthProperty.this.getData(stack).filter(a -> a.containsKey(id)).map(a -> ((EntityContext)a.get(id)).strength().getValue()).orElse(0.0))).append("\n").append((Component)Component.translatable((String)"miapi.property.entity.source")).append("\n");
                            edit.entities().forEach(context -> {
                                if (context instanceof HolderSet.Named) {
                                    HolderSet.Named named = (HolderSet.Named)context;
                                    component.append(Helper.getTranslation(named.key())).append("\n");
                                } else if (context instanceof HolderSet.ListBacked) {
                                    HolderSet.ListBacked listBacked = (HolderSet.ListBacked)context;
                                    listBacked.forEach(type -> component.append(((EntityType)type.value()).getDescription()).append("\n"));
                                }
                            });
                            return component;
                        }).build());
                    }
                });
                return displays;
            }
        });
    }

    public abstract Component getFallbackName(EntityType<?> var1);

    public abstract Component getBaseDescription(double var1);

    public double strengthForEntity(Holder<EntityType<?>> entity, ItemStack itemStack) {
        return this.getData(itemStack).map(a -> {
            double value = 0.0;
            for (EntityContext context : a.values()) {
                if (!context.contains(entity)) continue;
                value += context.strength().getValue();
            }
            return value;
        }).orElse(0.0);
    }

    public double strengthForEntity(Holder<EntityType<?>> entity, Iterable<ItemStack> stacks) {
        double strength = 0.0;
        for (ItemStack itemStack : stacks) {
            strength += this.strengthForEntity(entity, itemStack);
        }
        return strength;
    }

    @Override
    public Map<ResourceLocation, EntityContext> merge(Map<ResourceLocation, EntityContext> left, Map<ResourceLocation, EntityContext> right, MergeType mergeType) {
        MergeAble.mergeMap(left, right, mergeType, (key, l, r) -> new EntityContext(MergeAble.mergeList(l.entities(), r.entities(), mergeType), r.strength().merge(l.strength(), mergeType), MergeAble.decideLeftRight(r.name(), l.name(), mergeType)));
        return Map.of();
    }

    @Override
    public Map<ResourceLocation, EntityContext> initialize(Map<ResourceLocation, EntityContext> property, ModuleInstance context) {
        HashMap<ResourceLocation, EntityContext> init = new HashMap<ResourceLocation, EntityContext>();
        property.forEach((id, entityContext) -> init.put((ResourceLocation)id, new EntityContext(entityContext.entities, entityContext.strength.initialize(context), entityContext.name)));
        return init;
    }

    public record EntityContext(List<HolderSet<EntityType<?>>> entities, DoubleOperationResolvable strength, Optional<Component> name) {
        public static final Codec<EntityContext> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Miapi.toListOrSimple(RegistryCodecs.homogeneousList((ResourceKey)Registries.ENTITY_TYPE)).optionalFieldOf("entities", List.of()).forGetter(EntityContext::entities), (App)DoubleOperationResolvable.CODEC.optionalFieldOf("strength", (Object)new DoubleOperationResolvable(0.0)).forGetter(EntityContext::strength), (App)ComponentSerialization.CODEC.optionalFieldOf("name").forGetter(EntityContext::name)).apply((Applicative)instance, EntityContext::new));

        public boolean contains(Holder<EntityType<?>> entity) {
            for (HolderSet<EntityType<?>> holders : this.entities()) {
                if (!holders.contains(entity)) continue;
                return true;
            }
            return false;
        }

        @Nullable
        public EntityType<?> firstType() {
            for (HolderSet<EntityType<?>> holder : this.entities()) {
                HolderSet.ListBacked listBacked;
                Optional<EntityType> type;
                if (!(holder instanceof HolderSet.ListBacked) || !(type = (listBacked = (HolderSet.ListBacked)holder).stream().findFirst().map(Holder::value)).isPresent()) continue;
                return type.get();
            }
            return null;
        }
    }
}

