/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.potion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;
import smartin.miapi.modules.properties.util.InitializeAble;
import smartin.miapi.modules.properties.util.MergeType;

public record PossibleEffect(Holder<MobEffect> potion, DoubleOperationResolvable amplifier, DoubleOperationResolvable duration, DoubleOperationResolvable ambient, DoubleOperationResolvable showParticle, DoubleOperationResolvable showIcon, DoubleOperationResolvable probability, DoubleOperationResolvable targetSelf, EquipmentSlotGroup group) implements InitializeAble<PossibleEffect>
{
    public static final Codec<PossibleEffect> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MobEffect.CODEC.fieldOf("potion").forGetter(PossibleEffect::potion), (App)DoubleOperationResolvable.CODEC.optionalFieldOf("amplifier", (Object)new DoubleOperationResolvable(0.0)).forGetter(PossibleEffect::amplifier), (App)DoubleOperationResolvable.CODEC.optionalFieldOf("duration", (Object)new DoubleOperationResolvable(0.0)).forGetter(PossibleEffect::duration), (App)DoubleOperationResolvable.CODEC.optionalFieldOf("ambient", (Object)new DoubleOperationResolvable(0.0)).forGetter(PossibleEffect::ambient), (App)DoubleOperationResolvable.CODEC.optionalFieldOf("show_particles", (Object)new DoubleOperationResolvable(1.0)).forGetter(PossibleEffect::showParticle), (App)DoubleOperationResolvable.CODEC.optionalFieldOf("show_icon", (Object)new DoubleOperationResolvable(1.0)).forGetter(PossibleEffect::showIcon), (App)DoubleOperationResolvable.CODEC.optionalFieldOf("probability", (Object)new DoubleOperationResolvable(1.0)).forGetter(PossibleEffect::showIcon), (App)DoubleOperationResolvable.CODEC.optionalFieldOf("target_self", (Object)new DoubleOperationResolvable(1.0)).forGetter(PossibleEffect::showIcon), (App)EquipmentSlotGroup.CODEC.optionalFieldOf("equipment_slot", (Object)EquipmentSlotGroup.ANY).forGetter(PossibleEffect::group)).apply((Applicative)instance, PossibleEffect::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PossibleEffect> STREAM_CODEC = ByteBufCodecs.fromCodecWithRegistries(CODEC);

    public MobEffectInstance getEffect() {
        return new MobEffectInstance(this.potion(), (int)this.duration().getValue(), (int)this.amplifier().getValue(), this.ambient().isTrue(), this.showParticle().isTrue(), this.showIcon().isTrue());
    }

    public void apply(LivingEntity wielder, RandomSource random, @Nullable EquipmentSlot equipmentSlot, LivingEntity target, LivingEntity selfTarget) {
        if (equipmentSlot == null || this.group().test(equipmentSlot)) {
            if (this.targetSelf().isTrue()) {
                target = selfTarget;
            }
            if (target != null && (this.probability().getValue() == 1.0 || random.nextDouble() < this.probability().getValue())) {
                target.addEffect(this.getEffect(), (Entity)wielder);
            }
        }
    }

    public void apply(List<PossibleEffect> effects, LivingEntity wielder, RandomSource random, EquipmentSlot equipmentSlot, LivingEntity target, LivingEntity selfTarget) {
        effects.forEach(effect -> effect.apply(wielder, random, equipmentSlot, target, selfTarget));
    }

    public Component getTooltip(String key, String showTargetSelf) {
        return Component.translatable((String)(this.targetSelf().isTrue() ? showTargetSelf : key), (Object[])new Object[]{((MobEffect)this.potion().value()).getDisplayName(), (int)this.duration().getValue() / 20, (int)this.amplifier().getValue() + 1, this.probability().getValue() == 1.0 ? Component.empty() : this.probability()});
    }

    public static List<Component> getTooltip(Component header, List<PossibleEffect> effects, String key, String showTargetSelf) {
        ArrayList<Component> components = new ArrayList<Component>();
        if (!effects.isEmpty()) {
            components.add((Component)Component.empty());
            components.add(header);
            for (PossibleEffect effect : effects) {
                components.add(effect.getTooltip(key, showTargetSelf));
            }
        }
        return components;
    }

    public static void applyEffects(LivingEntity target, LivingEntity selfTarget, Iterable<ItemStack> items, LivingEntity causer, Function<ItemStack, List<PossibleEffect>> effectGetter) {
        for (ItemStack item : items) {
            effectGetter.apply(item).forEach(possibleEffect -> possibleEffect.apply(causer, causer.level().getRandom(), null, target, selfTarget));
        }
    }

    public static List<PossibleEffect> merge(List<PossibleEffect> left, List<PossibleEffect> right, MergeType mergeType) {
        ArrayList<PossibleEffect> mergedList = new ArrayList<PossibleEffect>();
        ArrayList<PossibleEffect> directMerged = new ArrayList<PossibleEffect>(left);
        directMerged.addAll(right);
        directMerged.forEach(possibleEffect -> {
            Optional<PossibleEffect> mergeWith = mergedList.stream().filter(possibleEffect1 -> possibleEffect1.potion().equals(possibleEffect.potion()) && possibleEffect1.targetSelf().isTrue() == possibleEffect.targetSelf().isTrue() && (int)possibleEffect1.amplifier().getValue() == (int)possibleEffect.amplifier().getValue()).findFirst();
            if (mergeWith.isPresent()) {
                PossibleEffect first = mergeWith.get();
                mergedList.remove(first);
                double combinedProbability = first.probability().getValue() + possibleEffect.probability().getValue();
                int combinedDuration = (int)(first.duration().getValue() + (combinedProbability > 1.0 ? (double)((int)(first.duration().getValue() * (combinedProbability - 1.0))) : first.duration().getValue()));
                combinedProbability = Math.min(combinedProbability, 1.0);
                mergedList.add(new PossibleEffect(first.potion, DoubleOperationResolvable.merge(first.amplifier, possibleEffect.amplifier, mergeType), new DoubleOperationResolvable(combinedDuration), DoubleOperationResolvable.merge(first.ambient, possibleEffect.ambient, mergeType), DoubleOperationResolvable.merge(first.showParticle, possibleEffect.showParticle, mergeType), DoubleOperationResolvable.merge(first.showIcon, possibleEffect.showIcon, mergeType), new DoubleOperationResolvable(combinedProbability), first.targetSelf, first.group()));
            } else {
                mergedList.add((PossibleEffect)possibleEffect);
            }
        });
        return mergedList;
    }

    @Override
    public PossibleEffect initialize(PossibleEffect original, ModuleInstance moduleInstance) {
        return new PossibleEffect(original.potion(), original.amplifier().initialize(moduleInstance), original.duration().initialize(moduleInstance), original.ambient().initialize(moduleInstance), original.showParticle().initialize(moduleInstance), original.showIcon().initialize(moduleInstance), original.probability().initialize(moduleInstance), original.targetSelf().initialize(moduleInstance), original.group());
    }
}

