/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.projectile;

import com.mojang.serialization.Codec;
import dev.architectury.event.EventResult;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import oshi.annotation.concurrent.Immutable;
import smartin.miapi.Miapi;
import smartin.miapi.events.MiapiProjectileEvents;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.item.modular.items.bows.ModularCrossbow;
import smartin.miapi.modules.properties.LoreProperty;
import smartin.miapi.modules.properties.projectile.MagazineCrossbowShotDelay;
import smartin.miapi.modules.properties.util.DoubleProperty;

public class RapidfireCrossbowProperty
extends DoubleProperty {
    public static final ResourceLocation KEY = Miapi.id("rapid_fire_crossbow");
    public static RapidfireCrossbowProperty property;
    public static DataComponentType<List<ItemStack>> ADDITIONAL_PROJECTILES_COMPONENT;

    public RapidfireCrossbowProperty() {
        super(KEY);
        property = this;
        MiapiProjectileEvents.MODULAR_CROSSBOW_POST_LOAD.register(context -> {
            if (!context.player.level().isClientSide()) {
                int shotCount = RapidfireCrossbowProperty.getShotCount(context.crossbow);
                ArrayList<ItemStack> projectiles = new ArrayList<ItemStack>(RapidfireCrossbowProperty.getSavedProjectilesOnCrossbow(context.crossbow));
                for (int i = projectiles.size(); i < shotCount; ++i) {
                    Player player2;
                    LivingEntity patt0$temp;
                    ItemStack otherAmmo = context.player.getProjectile(context.crossbow);
                    Player player = null;
                    if (!otherAmmo.isEmpty() && (patt0$temp = context.player) instanceof Player && !(player2 = (Player)patt0$temp).isCreative()) {
                        player = player2;
                    } else {
                        otherAmmo = otherAmmo.copy();
                    }
                    otherAmmo = otherAmmo.split(1);
                    if (otherAmmo.isEmpty()) continue;
                    if (otherAmmo.isDamageableItem()) {
                        // empty if block
                    }
                    projectiles.add(otherAmmo.copy());
                    if (player == null) continue;
                    player.getInventory().removeItem(otherAmmo);
                }
                RapidfireCrossbowProperty.writeProjectileListToCrossbow(context.crossbow, List.copyOf(projectiles));
            }
            return EventResult.pass();
        });
        MiapiProjectileEvents.MODULAR_CROSSBOW_POST_SHOT.register((player, crossbow) -> {
            Level patt0$temp;
            if (crossbow.getItem() instanceof ModularCrossbow && (patt0$temp = player.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt0$temp;
                ArrayList<ItemStack> projectiles = new ArrayList<ItemStack>(RapidfireCrossbowProperty.getSavedProjectilesOnCrossbow(crossbow));
                if (!projectiles.isEmpty()) {
                    ItemStack itemStack = (ItemStack)projectiles.remove(0);
                    crossbow.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.of((ItemStack)itemStack));
                    int projectileCount = EnchantmentHelper.processProjectileCount((ServerLevel)serverLevel, (ItemStack)crossbow, (Entity)player, (int)1);
                    for (int i = 1; i < projectileCount; ++i) {
                        crossbow.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.of((ItemStack)itemStack.copy()));
                    }
                    RapidfireCrossbowProperty.writeProjectileListToCrossbow(crossbow, projectiles);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayerEntity = (ServerPlayer)player;
                        serverPlayerEntity.getCooldowns().addCooldown(crossbow.getItem(), MagazineCrossbowShotDelay.property.getValue(crossbow).orElse(0.0).intValue());
                    }
                }
            }
            return EventResult.pass();
        });
        LoreProperty.loreSuppliers.add((stack, tooltip, context, info) -> {
            if (ModularItem.isModularItem(stack)) {
                List<ItemStack> projectiles = RapidfireCrossbowProperty.getSavedProjectilesOnCrossbow(stack);
                for (ItemStack projectile : projectiles) {
                    tooltip.add(Component.translatable((String)"miapi.crossbow.ammo.addition", (Object[])new Object[]{projectile.getHoverName()}));
                }
            }
        });
    }

    public static void writeProjectileListToCrossbow(ItemStack crossbow, List<ItemStack> projectiles) {
        crossbow.set(ADDITIONAL_PROJECTILES_COMPONENT, List.copyOf(projectiles));
    }

    @Immutable
    public static List<ItemStack> getSavedProjectilesOnCrossbow(ItemStack crossbow) {
        return (List)crossbow.getComponents().getOrDefault(ADDITIONAL_PROJECTILES_COMPONENT, List.of());
    }

    public static int getShotCount(ItemStack itemStack) {
        return property.getValue(itemStack).orElse(0.0).intValue();
    }

    static {
        ADDITIONAL_PROJECTILES_COMPONENT = DataComponentType.builder().persistent(Codec.list((Codec)ItemStack.CODEC)).networkSynchronized(ByteBufCodecs.fromCodec((Codec)Codec.list((Codec)ItemStack.CODEC))).build();
    }
}

